<div class="row">
  <div class="col-12">
      <form role="form" id="edit-user-roles">
          <div class="card-body">

              <div class="row">
                  <div class="form-group col-sm-12">
                      <label for="gender">@lang('Funções do usuário')</label>
                      <br>
                      <select class="selectpicker form-control" data-style="btn-outline-primary" data-size="10"
                          name="roles[]" multiple="multiple">
                          @foreach ($brunch->funcionalities as $funcionality)
                          <optgroup label="{{ $funcionality->name }}">
                              @foreach ($funcionality->roles as $role)
                              <option value="{{ $role->id }}" {{ $user->hasRole($role)? 'selected':'' }}>
                                  {{ $role->name }}
                              </option>
                              @endforeach
                          </optgroup>
                          @endforeach
                      </select>
                  </div>
              </div>

          </div>
          <!-- /.card-body -->
          <div class="card-footer">
              <button type="submit" class="btn btn-sm btn-outline-primary save">@lang('Salvar')</button>
              <button type="button" class="btn btn-sm btn-outline-success d-none saved">@lang('Salvo')</button>
              <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                      class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i>@lang('Salvando')</button>
              <button type="button" class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
          </div>
      </form>
  </div>
</div>

@push('js')


<script type="text/javascript">
  $(document).ready(function () {
      $.validator.setDefaults({
        submitHandler: saveNewRoles
      });
      $('#edit-user-roles').validate({
        rules: {

        },
        messages: {

        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
          error.addClass('invalid-feedback');
          element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
          $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
          $(element).removeClass('is-invalid');
        }
      });
    });

    $(document).ready(function () {
        $('.select2bs4').select2({
            theme: 'bootstrap4'
        })
    });


    function saveNewRoles(){
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
      });


        let data = $('form#edit-user-roles').serializeArray();

        $.ajax({
            ...ajaxSettings,
            method:'PUT',
            url: "{{ URL::signedRoute('api.company.brunch.users.update', ['user' => $user->id, 'brunch' => $brunch->id]) }}",
            data: data,
            beforeSend: function(){
              $('form#edit-user-roles button.save').addClass('d-none');
              $('form#edit-user-roles button.saved').addClass('d-none');
              $('form#edit-user-roles button.error').addClass('d-none');
              $('form#edit-user-roles button.saving').removeClass('d-none');
            },
            statusCode : {
                202: function(response){
                  Toast.fire({
                    type: 'success',
                    title: '@lang("Funções do usuário foram atualizadas").'
                  })

                  $('form#edit-user-roles button.save').addClass('d-none');
                  $('form#edit-user-roles button.saved').removeClass('d-none');
                  $('form#edit-user-roles button.saving').addClass('d-none');
                  $('form#edit-user-roles button.error').addClass('d-none');
                    setTimeout(() => {
                        goto(response.url.web);
                    }, 3000)
                },
                401:(response) =>{

                    Toast.fire({
                        type: 'error',
                        title: '@lang("Volte a fazer o login").'
                    });
                    $.ajax({
                        url: "{{ URL::signedRoute('web.system.exit') }}",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
                422:(response) =>{
                  Toast.fire({
                    type: 'error',
                    title: '@lang("Verifique os dados inseridos e submeta outra vez").'
                  })
                },
            },
            error: (response) => {
              $('form#edit-user-roles button.save').addClass('d-none');
              $('form#edit-user-roles button.saved').addClass('d-none');
              $('form#edit-user-roles button.saving').addClass('d-none');
              $('form#edit-user-roles button.error').removeClass('d-none');
              setTimeout(() => {
                $('form#edit-user-roles button.save').removeClass('d-none');
                $('form#edit-user-roles button.saved').addClass('d-none');
                $('form#edit-user-roles button.saving').addClass('d-none');
                $('form#edit-user-roles button.error').addClass('d-none');
              }, 2000)
            }
        });
    }
</script>
@endpush
