<div class="card">
    <div class="card-header p-2">
        <ul class="nav nav-pills">
            <li class="nav-item"><a class="nav-link active" href="#activity" data-toggle="tab">@lang('Funções')</a>
            </li>
            <li class="nav-item"><a class="nav-link" href="#timeline" data-toggle="tab">@lang('Editar')</a></li>
            <li class="nav-item"><a class="nav-link" href="#password" data-toggle="tab">@lang('Password')</a></li>
            <li class="nav-item"><a class="nav-link" href="#language" data-toggle="tab">@lang('Linguagem')</a></li>
        </ul>
    </div>
    <div class="card-body">
        <div class="tab-content">
            <div class="active tab-pane" id="activity">

                <div class="row">
                    <div class="col-12">
                        @foreach ($user->roles as $role)
                        <span class="badge badge-primary badge-pill m-1">{{ $role->name }}</span>
                        @endforeach
                    </div>
                    @can('manage-users', $brunch)
                    <div class="col-12">
                        @include('users.show.parts.mini.roles')
                    </div>
                    @endcan



                </div>
            </div>
            <div class="tab-pane" id="timeline">
                @include('users.show.parts.mini.data')

            </div>
            <div class="tab-pane" id="password">
                @include('users.show.parts.mini.password')
            </div>
            <div class="tab-pane" id="language">
                @include('users.show.parts.mini.language')
            </div>
        </div>
    </div>
</div>

@section('plugins.JqueryValidation', true)
@section('plugins.Select2', true)
@section('plugins.SelectPicker', true)
@section('plugins.Sweetalert2', true)
