@extends('adminlte::master')

@section('adminlte_css_pre')
<link rel="stylesheet" href="{{ secure_asset('vendor/icheck-bootstrap/icheck-bootstrap.min.css') }}">
@stop

@section('adminlte_css')
@php
$img = secure_asset('imgs/bgs/login-bg.jpg');
$img2 = secure_asset('imgs/bgs/pos.png');
@endphp
<style>
    .login-page {
        /* background-image: url('imgs/bgs/pos.png') !important;
        background-position: center !important;
        background-size: cover !important; */
background: rgb(244,227,214);
background: linear-gradient(98deg, rgba(244,227,214,1) 23%, rgba(0,121,111,1) 100%);
    }
</style>
@stack('css')
@yield('css')
@stop

@section('classes_body', 'login-page')

@php( $login_url = View::getSection('login_url') ?? config('adminlte.login_url', 'login') )
@php( $register_url = View::getSection('register_url') ?? config('adminlte.register_url', 'register') )
@php( $password_reset_url = View::getSection('password_reset_url') ?? config('adminlte.password_reset_url',
'password/reset') )
@php( $dashboard_url = View::getSection('dashboard_url') ?? config('adminlte.dashboard_url', 'home') )

@if (config('adminlte.use_route_url', false))
@php( $login_url = $login_url ? URL::signedRoute($login_url) : '' )
@php( $register_url = $register_url ? URL::signedRoute($register_url) : '' )
@php( $password_reset_url = $password_reset_url ? URL::signedRoute($password_reset_url) : '' )
@php( $dashboard_url = $dashboard_url ? URL::signedRoute($dashboard_url) : '' )
@else
@php( $login_url = $login_url ? url($login_url) : '' )
@php( $register_url = $register_url ? url($register_url) : '' )
@php( $password_reset_url = $password_reset_url ? url($password_reset_url) : '' )
@php( $dashboard_url = $dashboard_url ? url($dashboard_url) : '' )
@endif



@section('body')

<div class="login-box">
    <a href="{{ $dashboard_url }}" ><img src="imgs/bgs/pos.png" alt="NetwarePos" width="350" class="mr-5 mb-3"></a>
    <div class="card">
        <div class="card-body login-card-body">
            <p class="login-box-msg">{{ __('adminlte::adminlte.login_message') }}</p>
            <form action="{{ $login_url }}" method="post">
                {{ csrf_field() }}
                <div class="input-group mb-3">
                    <input type="email" name="email"
                        class="form-control {{ $errors->has('email') ? 'is-invalid' : '' }}" value="{{ old('email') }}"
                        placeholder="{{ __('adminlte::adminlte.email') }}" autofocus>
                    <div class="input-group-append">
                        <div class="input-group-text">
                            <span class="fas fa-envelope"></span>
                        </div>
                    </div>
                    @if ($errors->has('email'))
                    <div class="invalid-feedback">
                        {{ $errors->first('email') }}
                    </div>
                    @endif
                </div>
                <div class="input-group mb-3">
                    <input type="password" name="password"
                        class="form-control {{ $errors->has('password') ? 'is-invalid' : '' }}"
                        placeholder="{{ __('adminlte::adminlte.password') }}">
                    <div class="input-group-append">
                        <div class="input-group-text">
                            <span class="fas fa-lock"></span>
                        </div>
                    </div>
                    @if ($errors->has('password'))
                    <div class="invalid-feedback">
                        {{ $errors->first('password') }}
                    </div>
                    @endif
                </div>
                <div class="row">
                    <div class="col-8">
                        <div class="icheck-primary">
                            <input type="checkbox" name="remember" id="remember">
                            <label for="remember">{{ __('adminlte::adminlte.remember_me') }}</label>
                        </div>
                    </div>
                    <div class="col-4">
                        <button type="submit" class="btn btn-block btn-flat" style="background-color: #e78f4d; color: white">
                            {{ __('adminlte::adminlte.sign_in') }}
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

</div>

<footer class="page-footer font-small blue">

  <!-- Copyright -->
  <div class="footer-copyright text-center py-3">
    <a href="https://www.netwarepos.com" target="blank" style="color: white">Visite a nossa pagina oficial</a>
  </div>
  <!-- Copyright -->

</footer>
<!-- Footer -->
@stop

@section('adminlte_js')
<script type="text/javascript" src="{{ secure_asset('vendor/adminlte/dist/js/adminlte.min.js') }}"></script>
@stack('js')
@yield('js')
@stop
