<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware(['auth:api'])->group(function () {
    Route::group(['prefix' => 'company', 'as' => 'company.'], function () {

        Route::apiResource('brunch',   'api\company\BrunchController',                 ['only' => ['store', 'update', 'destroy']]); //web.company.basic.[method]
        Route::prefix('brunch')->group(function () {
            Route::apiResource('{brunch}/configuration',   'api\company\BasicSaleOptionController',        ['as' => 'brunch', 'only' => ['store']]);
            Route::apiResource('{brunch}/crm',             'api\company\crm\CRMConfigurationController',   ['as' => 'brunch', 'only' => ['index', 'store', 'show']]);
            Route::apiResource('{brunch}/users',           'api\users\UserController',                     ['as' => 'brunch']);

            Route::post('{brunch}/logo',                'api\company\BrunchController@photo')->name('brunch.photo');
        });
        Route::apiResource('master',   'api\company\MasterController',                 ['only' => ['store', 'update', 'destroy']]);
    });
});
