<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware(['auth:api'])->group(function () {
    Route::match(['get', 'post'], 'customer/bills',        'api\customers\CustomerController@searchBills')
        ->name('customer.search.bills');
    Route::apiResource('customer',        'api\customers\CustomerController');
    Route::apiResource('customer/{customer}/statement', 'api\customers\CustomerOperationController', ['as' => 'customer']);
});
