<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\api\sales\ProformaController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware(['auth:api'])->group(function () {
    Route::group(['prefix' => 'sales', 'as' => 'sales.'], function () {
        Route::apiResource('returns',              'api\sales\ReturnSaleController',               ['only' => ['index', 'show', 'update']])->middleware('can:manage-shifts');

        Route::apiResource('basic',        'api\sales\BasicSaleController', ['only' => ['index', 'show', 'update']])->middleware('can:issue-or-return-basicsale');
        Route::apiResource('basic/{basic}/item',        'api\sales\relation\ItemSalableBasicController',       ['as' => 'basic',       'only' => ['store', 'destroy']])->middleware('can:issue-or-return-basicsale');

        Route::apiResource('invoice',                   'api\sales\InvoiceController', ['only' => ['index', 'show', 'update']])->middleware('can:issue-invoice');
        Route::apiResource('invoice/{invoice}/item',        'api\sales\relation\ItemSalableInvoiceController',       ['as' => 'invoice',       'only' => ['store', 'destroy']])->middleware('can:issue-invoice');


        Route::apiResource('delivery_note',                   'api\sales\DeliveryNoteController', ['only' => ['index', 'show', 'update']])->middleware('can:issue-delivery_note');
        Route::apiResource('delivery_note/{delivery_note}/item',        'api\sales\relation\ItemSalableDeliveryNoteController',       ['as' => 'delivery_note',       'only' => ['store', 'destroy']])->middleware('can:issue-delivery_note');



        Route::apiResource('recipt',       'api\sales\ReceiptController', ['only' => ['index', 'show', 'update']])->middleware('can:issue-recipt');
        Route::apiResource('recipt/{recipt}/item',             'api\sales\relation\ItemReciptController',             ['as' => 'recipt',      'only' => ['store', 'destroy']])->middleware('can:issue-recipt');

        Route::apiResource('cashsale',     'api\sales\CashSaleController', ['only' => ['index', 'show', 'update']])->middleware('can:issue-cashsale');
        Route::apiResource('cashsale/{cashsale}/item',         'api\sales\relation\ItemSalableCashSaleController',    ['as' => 'cashsale',    'only' => ['store', 'destroy']])->middleware('can:issue-cashsale');

        Route::apiResource('proforma',     'api\sales\ProformaController', ['only' => ['index', 'show', 'update']])->middleware('can:issue-proforma');
        Route::apiResource('proforma/{proforma}/item',         'api\sales\relation\ItemSalableProformaController',    ['as' => 'proforma',    'only' => ['store', 'destroy']])->middleware('can:issue-proforma');

        Route::post('proforma/{proforma}/copy',     [ProformaController::class, 'copy'])
            ->name('proformas.copy')
            ->middleware('can:issue-proforma');



        Route::apiResource('creditnote',   'api\sales\CreditNoteController', ['only' => ['index', 'show', 'update']])->middleware('can:issue-creditnote');
        Route::apiResource('creditnote/{creditnote}/item',     'api\sales\relation\ItemSalableCreditNoteController',  ['as' => 'creditnote',  'only' => ['store', 'destroy']])->middleware('can:issue-creditnote');


        Route::apiResource('debitnote',    'api\sales\DebitNoteController')
            ->only(['index', 'show', 'update'])
            ->middleware('can:issue-debitnote');

        Route::apiResource('debitnote.item',       'api\sales\relation\ItemSalableDebitNoteController',   ['only' => ['store', 'destroy']])
            ->only(['store', 'destroy'])
            ->parameters([
                'debitnote' => 'debitnote'
            ])
            ->middleware('can:issue-debitnote');

        Route::prefix('copy')->group(function () {
            Route::prefix('invoice/{invoice}/to')->group(function () {
                Route::post('basicsale',    'api\sales\InvoiceController@copyToBasicsale')->name('invoice.copy.basicsale')->middleware('can:issue-basicsale');
                Route::post('invoice',      'api\sales\InvoiceController@copyToInvoice')->name('invoice.copy.invoice')->middleware('can:issue-invoice');
                Route::post('cashsale',     'api\sales\InvoiceController@copyToCashsale')->name('invoice.copy.cashsale')->middleware('can:issue-cashsale');
                Route::post('proforma',     'api\sales\InvoiceController@copyToProforma')->name('invoice.copy.proforma')->middleware('can:issue-proforma');
                Route::post('creditnote',   'api\sales\InvoiceController@copyToCreditnote')->name('invoice.copy.creditnote')->middleware('can:issue-creditnote');
                Route::post('debitnote',    'api\sales\InvoiceController@copyToDebitnote')->name('invoice.copy.debitnote')->middleware('can:issue-debitnote');
            });
        });
    });


    Route::group(['prefix' => 'reports', 'as' => 'reports.sales.'], function () {
        Route::get('{company}/sales/current/month', 'api\sales\ReportController@currentMonth')->name('current.month');
        Route::get('{company}/sales/last/month', 'api\sales\ReportController@last30DaysSales')->name('last.month');
        Route::get('{company}/sales/last/year', 'api\sales\ReportController@last12MonthsSales')->name('last.year');
        Route::get('{company}/sales/last/week', 'api\sales\ReportController@last7DaysSales')->name('last.week');
        Route::get('{company}/sales/current/year', 'api\sales\ReportController@thisYearSales')->name('current.year');




        Route::match(['get', 'post'], '{company}/basic',        'api\sales\BasicSaleController@generateReport')->name('basic.report')->middleware('can:check-company-particular-reports');
        Route::match(['get', 'post'], '{company}/invoice',      'api\sales\InvoiceController@generateReport')->name('invoice.report')->middleware(['can:issue-invoice']);
        Route::match(['get', 'post'], '{company}/invoice-by-delivery',      'api\sales\InvoiceByDeliverNotesController@generateReport')->name('invoice.by.delivery.report')->middleware(['can:issue-invoice']); //new
        Route::match(['get', 'post'], '{company}/delivery-note',      'api\sales\DeliveryNoteController@generateReport')->name('delivery_note.report')->middleware(['can:issue-delivery_note']);
        Route::match(['get', 'post'], '{company}/cashsale',     'api\sales\CashSaleController@generateReport')->name('cashsale.report')->middleware(['can:issue-cashsale']);
        Route::match(['get', 'post'], '{company}/proforma',     'api\sales\ProformaController@generateReport')->name('proforma.report')->middleware(['can:issue-proforma']);



        // Todo:
        Route::match(['get', 'post'], '{company}/debitnote',    'api\sales\BasicSaleController@generateReport')->name('debitnote.report')->middleware(['can:access', 'can:issue-debitnote']);
        Route::match(['get', 'post'], '{company}/creditnote',   'api\sales\BasicSaleController@generateReport')->name('creditnote.report')->middleware(['can:access', 'can:issue-creditnote']);
        Route::match(['get', 'post'], '{company}/recipt',       'api\sales\BasicSaleController@generateReport')->name('recipt.report')->middleware(['can:access', 'can:issue-recipt']);
    });
});
