<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::middleware(['auth:api', 'can:manage-stock'])->group(function () {
    Route::group(['prefix' => 'stock', 'as' => 'stock.'], function () {


        Route::prefix('transfers')->group(function () {
            Route::apiResource('groups',        'api\stock\transference\TransferenceGroupController');
            Route::apiResource('groups.transfers',  'api\stock\transference\TransferenceController');

            Route::prefix('groups/{group}')->group(function () {
                Route::put('cancel', 'api\stock\transference\TransferenceGroupController@cancel')->name('groups.cancel');
                Route::put('finalize', 'api\stock\transference\TransferenceGroupController@finalize')->name('groups.finalize');
            });
        });

        Route::match(['get', 'post'], '/inventory', 'api\stock\StockMoveController@inventory')->name('inventory');
        Route::post('/inventory/adjust', 'api\stock\StockMoveController@adjust')->name('inventory.adjust');

        Route::match(['get', 'post'],   'saleable/sales/report',    'api\stock\SaleableController@sales')->name('saleable.sales.report');
        Route::match(['get', 'post'],   'category/sales/report',    'api\stock\CategoryController@sales')->name('category.sales.report');

        Route::apiResource('saleable',         'api\stock\SaleableController');

        Route::match(['get', 'post'],   'saleable/{saleable}/statement',    'api\stock\SaleableController@statement')->name('saleable.statement');



        Route::apiResource('providers',        'api\stock\ProviderController');

        Route::apiResource('providers/{provider}/purchases',                    'api\provider\PurchaseController', ['as' => 'providers']);
        Route::put('providers/{provider}/purchases/{purchase}/pay',             'api\provider\PurchaseController@pay')->name('providers.purchases.pay');
        Route::post('providers/{provider}/purchases/{purchase}/attachment',     'api\provider\PurchaseController@attachment')->name('providers.purchases.attachment');

        Route::apiResource('providers/{provider}/expenses',                 'api\provider\ExpensesController',  ['as' => 'providers']);
        Route::put('providers/{provider}/expenses/{expense}/pay',           'api\provider\ExpensesController@pay')->name('providers.expenses.pay');
        Route::post('providers/{provider}/expenses/{expense}/attachment',   'api\provider\ExpensesController@attachment')->name('providers.expenses.attachment');

        Route::apiResource('warehouse',        'api\stock\WarehouseController');
        Route::apiResource('saleunit',         'api\stock\SaleUnitController');
        Route::apiResource('category',         'api\stock\CategoryController');
        Route::apiResource('move',             'api\stock\StockMoveController', ['only' => ['index', 'destroy', 'store']]);

        Route::prefix('move')->group(function () {
            Route::put('cancel', 'api\stock\StockMoveController@cancel')->name('move.cancel');
            Route::put('finalize', 'api\stock\StockMoveController@finalize')->name('move.finalize');
        });
    });
});
