<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::name('web.')->group(function () {
    Route::middleware(['auth'])->group(function () {
        Route::group(['prefix' => 'company', 'as' => 'company.'], function () {
            Route::resource('brunch', 'web\company\BrunchController', ['only' => ['index', 'create', 'show', 'edit']]); //web.company.brunch.[method]
            Route::prefix('brunch')->group(function () {
                Route::resource('{brunch}/configuration',   'web\company\CompanyHomeController',            ['as' => 'brunch', 'only' => ['index']]);
                Route::resource('{brunch}/crm',             'web\company\crm\CRMConfigurationController',   ['as' => 'brunch', 'only' => ['index', 'create', 'show']]);
                Route::resource('{brunch}/users',           'web\users\UserController',                     ['as' => 'brunch', 'only' => ['index', 'create', 'show']]);
            });
            Route::resource('master', 'web\company\MasterController', ['only' => ['index', 'edit']]);
        });
    });
});
