<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::name('web.')->group(function () {
    Route::middleware(['auth'])->group(function () {
        Route::group(['prefix' => 'sales', 'as' => 'sales.'], function () {

            Route::resource('returns',          'web\sales\ReturnSaleController', ['only' => ['index', 'show', 'create']])->middleware('can:manage-shifts');
            Route::get('returns/{return}/print',       'web\sales\ReturnSaleController@print')->name('returns.print')->middleware('can:issue-or-return-basicsale');


            Route::resource('basic',                'web\sales\BasicSaleController', ['only' => ['index', 'show', 'create', 'edit']])->middleware('can:issue-basicsale');
            Route::get('basic/{basic}/print',       'web\sales\BasicSaleController@print')->name('basic.print')->middleware('can:issue-basicsale');
            Route::get('basic/{basic}/cancel',       'web\sales\BasicSaleController@cancel')->name('basic.cancel')->middleware('can:issue-basicsale');

            //Invoice pure
            Route::resource('invoice',              'web\sales\InvoiceController', ['only' => ['index', 'show', 'create', 'edit']])->middleware('can:issue-invoice');
            Route::get('invoice/{invoice}/print',   'web\sales\InvoiceController@print')->name('invoice.print')->middleware('can:issue-invoice');
            Route::get('invoice/{invoice}/pdf',   'web\sales\InvoiceController@pdf')->name('invoice.print.pdf')->middleware('can:issue-invoice');
            Route::get('invoice/{invoice}/cancel',   'web\sales\InvoiceController@cancel')->name('invoice.cancel')->middleware('can:issue-invoice');

            //invoice by delivery Notes
            Route::resource('invoices',              'web\sales\InvoiceByDeliverNotesController', ['only' => ['index', 'show', 'create', 'edit']])->middleware('can:issue-invoice');
            Route::get('invoices/{invoice}/print',   'web\sales\InvoiceByDeliverNotesController@print')->name('invoices.print')->middleware('can:issue-invoice');
            Route::get('invoices/{invoice}/pdf',   'web\sales\InvoiceByDeliverNotesController@pdf')->name('invoices.print.pdf')->middleware('can:issue-invoice');
            Route::get('invoices/{invoice}/cancel',   'web\sales\InvoiceByDeliverNotesController@cancel')->name('invoices.cancel')->middleware('can:issue-invoice');

            //delivery Notes
            Route::resource('delivery_note',              'web\sales\DeliveryNoteController', ['only' => ['index', 'show', 'create', 'edit']])->middleware('can:issue-delivery_note');
            Route::get('delivery_note/{delivery_note}/print',   'web\sales\DeliveryNoteController@print')->name('delivery_note.print')->middleware('can:issue-delivery_note');
            Route::get('delivery_note/{delivery_note}/pdf',   'web\sales\DeliveryNoteController@pdf')->name('delivery_note.print.pdf')->middleware('can:issue-delivery_note');
            Route::get('delivery_note/{delivery_note}/cancel',   'web\sales\DeliveryNoteController@cancel')->name('delivery_note.cancel')->middleware('can:issue-delivery_note');



            Route::resource('recipt',               'web\sales\ReceiptController', ['only' => ['index', 'show', 'create', 'edit']])->middleware('can:issue-recipt');
            Route::get('recipt/{recipt}/print',     'web\sales\ReceiptController@print')->name('recipt.print')->middleware('can:issue-recipt');
            Route::get('recipt/{recipt}/pdf',     'web\sales\ReceiptController@pdf')->name('recipt.print.pdf')->middleware('can:issue-recipt');


            Route::resource('cashsale',     'web\sales\CashSaleController', ['only' => ['index', 'show', 'create', 'edit']])->middleware('can:issue-cashsale');
            Route::get('cashsale/{cashsale}/print', 'web\sales\CashSaleController@print')->name('cashsale.print')->middleware('can:issue-cashsale');
            Route::get('cashsale/{cashsale}/pdf', 'web\sales\CashSaleController@pdf')->name('cashsale.print.pdf')->middleware('can:issue-cashsale');

            Route::resource('proforma',     'web\sales\ProformaController', ['only' => ['index', 'show', 'create', 'edit']])->middleware('can:issue-proforma');
            Route::get('proforma/{proforma}/print', 'web\sales\ProformaController@print')->name('proforma.print')->middleware('can:issue-proforma');
            Route::get('proforma/{proforma}/pdf', 'web\sales\ProformaController@pdf')->name('proforma.print.pdf')->middleware('can:issue-proforma');



            Route::resource('creditnote',   'web\sales\CreditNoteController', ['only' => ['index', 'show', 'create', 'edit']])->middleware('can:issue-creditnote');
            Route::get('creditnote/{creditnote}/print', 'web\sales\CreditNoteController@print')->name('creditnote.print')->middleware('can:issue-creditnote');
            Route::get('creditnote/{creditnote}/pdf', 'web\sales\CreditNoteController@pdf')->name('creditnote.print.pdf')->middleware('can:issue-creditnote');




            Route::resource('debitnote',                'web\sales\DebitNoteController', ['only' => ['index', 'show', 'create', 'edit']])->middleware('can:issue-debitnote');
            Route::get('debitnote/{debitnote}/print',   'web\sales\DebitNoteController@print')->name('debitnote.print')->middleware('can:issue-debitnote');
            Route::get('debitnote/{debitnote}/pdf',     'web\sales\DebitNoteController@pdf')->name('debitnote.print.pdf')->middleware('can:issue-debitnote');


            Route::prefix('reports')->group(function () {
                Route::get('generator',             'web\sales\ReportController@generate')->name('report.generate');
                Route::post('generator',             'web\sales\ReportController@generatePDF')->name('report.generate.pdf');


                Route::match(['get', 'post'], 'summary',             'web\sales\ReportController@generic')->name('report.summary');



                Route::match(['get', 'post'], 'basic',        'web\sales\BasicSaleController@report')->name('basic.report')->middleware('can:check-company-particular-reports');
                Route::match(['get', 'post'], 'invoice',      'web\sales\InvoiceController@report')->name('invoice.report')->middleware(['can:issue-invoice']);
                Route::match(['get', 'post'], 'invoice-by-delivery',      'web\sales\InvoiceByDeliverNotesController@report')->name('invoice.report.by.delivery')->middleware(['can:issue-invoice']);
                Route::match(['get', 'post'], 'delivery-note',      'web\sales\DeliveryNoteController@report')->name('deliverynote.report')->middleware(['can:issue-delivery_note']);
                Route::match(['get', 'post'], 'cashsale',     'web\sales\CashSaleController@report')->name('cashsale.report')->middleware(['can:issue-cashsale']);
                Route::match(['get', 'post'], 'proforma',     'web\sales\ProformaController@report')->name('proforma.report')->middleware(['can:issue-proforma']);


                Route::match(['get', 'post'], 'debitnote',    'web\sales\ReportController@debitnote')->name('debitnote.report')->middleware(['can:access', 'can:issue-debitnote']);
                Route::match(['get', 'post'], 'creditnote',   'web\sales\ReportController@creditnote')->name('creditnote.report')->middleware(['can:access', 'can:issue-creditnote']);
                Route::match(['get', 'post'], 'recipt',       'web\sales\ReportController@recipt')->name('recipt.report')->middleware(['can:access', 'can:issue-recipt']);
            });
        });
    });
});
