<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::name('web.')->group(function () {
    Route::middleware(['auth'])->group(function () {
        Route::group(['prefix' => 'shift', 'as' => 'shift.'], function () {
            Route::get('/current', 'web\shifts\ShiftController@current')->name('current')->middleware('can:sale');
            Route::get('/opened', 'web\shifts\ShiftController@opened')->name('opened')->middleware('can:manage-shifts');


            Route::get('',                  'web\shifts\ShiftController@index')->name('index')->middleware(['can:manage-shifts']);
            Route::get('{shift}/show',      'web\shifts\ShiftController@show')->name('show')->middleware(['can:touch-shifts', 'can:view,shift']);
            Route::get('{shift}/pdf',       'web\shifts\ShiftController@pdf')->name('pdf')->middleware(['can:manage-shifts', 'can:view,shift']);
            Route::get('{shift}/thermal',   'web\shifts\ShiftController@thermal')->name('thermal')->middleware(['can:manage-shifts', 'can:view,shift']);


            Route::get('{shift}/basic',     'web\shifts\ShiftController@basic')->name('basic')->middleware(['can:manage-shifts', 'can:view,shift']);
            Route::get('{shift}/cashsale',  'web\shifts\ShiftController@cashsale')->name('cashsale')->middleware(['can:manage-shifts', 'can:view,shift']);
            Route::get('{shift}/invoice',   'web\shifts\ShiftController@invoice')->name('invoice')->middleware(['can:manage-shifts', 'can:view,shift']);
            Route::get('{shift}/debitnote',     'web\shifts\ShiftController@debitnote')->name('debitnote')->middleware(['can:manage-shifts', 'can:view,shift']);
            Route::get('{shift}/creditnote',    'web\shifts\ShiftController@creditnote')->name('creditnote')->middleware(['can:manage-shifts', 'can:view,shift']);
            Route::get('{shift}/recipt',    'web\shifts\ShiftController@recipt')->name('recipt')->middleware(['can:manage-shifts', 'can:view,shift']);
        });
    });
});
