<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::name('web.')->group(function () {
    Route::middleware(['auth', 'can:manage-stock'])->group(function () {
        Route::group(['prefix' => 'stock', 'as' => 'stock.'], function () {


            Route::resource('transfers', 'web\stock\transference\TransferenceGroupController',     ['only' => ['index', 'show', 'create']]);

            Route::prefix('transfers')->group(function () {
                Route::resource('groups', 'web\stock\transference\TransferenceGroupController',     ['only' => ['index', 'show', 'create']]);
            });


            Route::prefix('inventory')->group(function () {
                Route::get('',          'web\stock\StockMoveController@inventory')->name('inventory');
                Route::get('thermal',   'web\stock\StockMoveController@thermal')->name('inventory.thermal');
                Route::get('a4',        'web\stock\StockMoveController@a4')->name('inventory.a4');
                Route::any('adjust',    'web\stock\StockMoveController@adjust')->name('inventory.adjust');
            });

            Route::prefix('tools')->group(function () {
                Route::get('',        'web\stock\StockMoveController@toolslist')->name('tools');
                Route::get('stockbyqty',        'web\stock\StockMoveController@stockbyqty')->name('tools.stock');
                Route::get('expiredsaleable',        'web\stock\StockMoveController@expiredsaleable')->name('tools.expiredsaleable');
            });

            Route::resource('saleable',                         'web\stock\SaleableController',     ['only' => ['index', 'show', 'create']]);
            Route::match(['get', 'post'],   'saleable/{saleable}/statement',    'api\stock\SaleableController@statement')->name('saleable.statement');

            Route::resource('providers',                        'web\stock\ProviderController',     ['only' => ['index', 'show', 'create']]);
            Route::resource('providers/{provider}/purchases',   'web\provider\PurchaseController',  ['as' => 'providers', 'only' => ['index', 'show', 'create']]);
            Route::resource('providers/{provider}/expenses',   'web\provider\ExpensesController',  ['as' => 'providers', 'only' => ['index', 'show', 'create']]);
            Route::match(['get', 'post'], 'providers/{provider}/statement', 'web\provider\ProviderOperationController@index')->name('providers.statement');

            Route::resource('warehouse',                        'web\stock\WarehouseController',    ['only' => ['index', 'show', 'create']]);
            Route::resource('saleunit',                         'web\stock\SaleUnitController',     ['only' => ['index', 'show', 'create']]);
            Route::resource('category',                         'web\stock\CategoryController',     ['only' => ['index', 'show', 'create']]);
            Route::resource('move',                             'web\stock\StockMoveController',    ['only' => ['index', 'create']]);
        });
    });
});
