<form role="form" id="saleable-statement">
    <div class="row">

        <div class="form-group col-sm-6">
            <label for="warehouse"><?php echo app('translator')->get('Armazem'); ?></label>
            <select name="warehouse" class="form-control select2bs4" style="width: 100%;"
                data-placeholder="<?php echo app('translator')->get('Seleciona a unidade de venda'); ?>">
                <?php $__currentLoopData = $warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warehouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($warehouse->id); ?>"><?php echo e($warehouse->name); ?>

                </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>


        <div class="form-group col-sm-12">
            <button type="submit" class="btn btn-sm btn-outline-primary save"><?php echo app('translator')->get('Processar'); ?></button>
            <button type="button" class="btn btn-sm btn-outline-success d-none saved"><?php echo app('translator')->get('Processao'); ?></button>
            <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                    class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i><?php echo app('translator')->get('Processando'); ?></button>
            <button type="button" class="btn btn-sm btn-outline-danger d-none error"><?php echo app('translator')->get('Erro'); ?></button>
        </div>
    </div>
</form>


<?php $__env->startSection('plugins.JqueryValidation', true); ?>
<?php $__env->startSection('plugins.Select2', true); ?>
<?php $__env->startSection('plugins.Sweetalert2', true); ?>
<?php $__env->startSection('plugins.BootstrapSwitch', true); ?>

<?php $__env->startPush('js'); ?>
<script type="text/javascript">
    $(document).ready(function () {
      $.validator.setDefaults({
        submitHandler: generateStatement
      });

      $('#saleable-statement').validate({
        rules: {

        },
        messages: {

        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
          error.addClass('invalid-feedback');
          element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
          $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
          $(element).removeClass('is-invalid');
        }
      });
    });

    $(document).ready(function () {
        $('.select2bs4').select2({
            theme: 'bootstrap4'
        })
    });


    function generateStatement(){
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
      });


        let data = $('form#saleable-statement').serializeArray();

        $.ajax({
            ...ajaxSettings,
            method:'POST',
            url: "<?php echo e(URL::route('api.stock.saleable.statement', ['saleable'=>$saleable->id])); ?>",
            data: data,
            beforeSend: function(){
              $('form#saleable-statement button.save').addClass('d-none');
              $('form#saleable-statement button.saved').addClass('d-none');
              $('form#saleable-statement button.error').addClass('d-none');
              $('form#saleable-statement button.saving').removeClass('d-none');
            },
            statusCode : {
                200: function(response){


                  $('form#saleable-statement button.save').removeClass('d-none');
                  $('form#saleable-statement button.saved').addClass('d-none');
                  $('form#saleable-statement button.saving').addClass('d-none');
                  $('form#saleable-statement button.error').addClass('d-none');

                  handlebar.init(response.data)

                },
                401:(response) =>{

                    Toast.fire({
                        type: 'error',
                        title: '<?php echo app('translator')->get("Volte a fazer o login"); ?>.'
                    })

                    $.ajax({
                        url: "<?php echo e(URL::route('web.system.exit')); ?>",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
                422:(response) =>{
                  Toast.fire({
                    type: 'error',
                    title: '<?php echo app('translator')->get("Verifique os dados inseridos e submeta outra vez"); ?>.'
                  })
                },
            },
            error: (response) => {
              $('form#saleable-statement button.save').addClass('d-none');
              $('form#saleable-statement button.saved').addClass('d-none');
              $('form#saleable-statement button.saving').addClass('d-none');
              $('form#saleable-statement button.error').removeClass('d-none');
              setTimeout(() => {
                $('form#saleable-statement button.save').removeClass('d-none');
                $('form#saleable-statement button.saved').addClass('d-none');
                $('form#saleable-statement button.saving').addClass('d-none');
                $('form#saleable-statement button.error').addClass('d-none');
              }, 2000)
            }
        });
    }
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/stock/saleable/show/parts/mini/form-statement.blade.php ENDPATH**/ ?>