<div class="container-fluid">
    <div class="row">
        <!-- left column -->
        <div class="col-md-12">
            <!-- jquery validation -->
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title"><?php echo app('translator')->get('Dados da sucursal'); ?></h3>
                </div>
                <!-- /.card-header -->
                <form role="form" class="m-2" id="create-brunch-company">
                    <div class="row">
                        <div class="form-group col-sm-4">
                            <label for="name"><?php echo app('translator')->get('Nome'); ?></label>
                            <input type="text" name="name" class="form-control" id="name"
                                placeholder="Terminal 004 Lda">
                        </div>

                        <div class="form-group col-sm-4">
                            <label for="nuit"><?php echo app('translator')->get('NUIT'); ?></label>
                            <input type="text" name="nuit" class="form-control" id="nuit" placeholder="125896321">
                        </div>

                        <div class="form-group col-sm-4">
                            <label for="vat_scheme"><?php echo app('translator')->get('Regime de IVA'); ?></label>
                            <select name="vat_scheme" class="form-control select2bs4" style="width: 100%;"
                                data-placeholder="<?php echo app('translator')->get('Seleciona regime da empresa'); ?>">
                                <?php $__currentLoopData = $vatschemes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $scheme): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($scheme->id); ?>"><?php echo e($scheme->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group col-sm-4">
                            <label for="country"><?php echo app('translator')->get('País'); ?></label>
                            <input type="text" name="country" class="form-control" id="country"
                                placeholder="Mozambique">
                        </div>

                        <div class="form-group col-sm-4">
                            <label for="city"><?php echo app('translator')->get('Cidade'); ?></label>
                            <input type="text" name="city" class="form-control" id="city" placeholder="Mozambique">
                        </div>

                        <div class="form-group col-sm-4">
                            <label for="address"><?php echo app('translator')->get('Endereço'); ?></label>
                            <input type="text" name="address" class="form-control" id="address"
                                placeholder="Av.24 de Julho #105">
                        </div>

                        <div class="form-group col-sm-6">
                            <label for="phone"><?php echo app('translator')->get('Telefone'); ?></label>
                            <input type="text" name="phone" class="form-control" id="phone" placeholder="823847556">
                        </div>

                        <div class="form-group col-sm-6">
                            <label for="email"><?php echo app('translator')->get('Email'); ?></label>
                            <input type="email" name="email" class="form-control" id="email"
                                placeholder="exemplo@mail.com">
                        </div>






                        <div class="form-group col-sm-12">
                            <label for="gender"><?php echo app('translator')->get('Funcionalidades'); ?></label>
                            <select class="select2bs4" name="funcionalities[]" multiple="multiple"
                                data-placeholder="<?php echo app('translator')->get('Selecione as funcionalidades da sucursal'); ?>"
                                style="width: 100%;">
                                <?php $__currentLoopData = $funcionalities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($role->id); ?>"> <?php echo e($role->name); ?> </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>


                    </div>



                    <div class="row">
                        <div class="form-group col-12">
                            <!-- /.card-body -->
                            <button type="submit" class="btn btn-sm btn-outline-primary save"><?php echo app('translator')->get('Salvar'); ?></button>
                            <button type="button"
                                class="btn btn-sm btn-outline-success d-none saved"><?php echo app('translator')->get('Salvo'); ?></button>
                            <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                                    class="fa fa-spinner fa-spin fa-circle-notch"
                                    aria-hidden="true"></i><?php echo app('translator')->get('Salvando'); ?></button>
                            <button type="button"
                                class="btn btn-sm btn-outline-danger d-none error"><?php echo app('translator')->get('Erro'); ?></button>
                        </div>
                    </div>
                </form>

            </div>
            <!-- /.card -->
        </div>
        <!--/.col (left) -->
    </div>
    <!-- /.row -->
</div>


<?php $__env->startSection('plugins.JqueryValidation', true); ?>
<?php $__env->startSection('plugins.Select2', true); ?>
<?php $__env->startSection('plugins.Sweetalert2', true); ?>
<?php $__env->startPush('js'); ?>
<script type="text/javascript">
    $(document).ready(function () {
      $.validator.setDefaults({
        submitHandler: saveCompanyData
      });
      $('#create-brunch-company').validate({
        rules: {
            name:{
                required:true,
                minlength:2
            },
            nuit:{
                required:true,
                minlength:9,
                maxlength:9
            },
            country:{
                required:true,
                minlength:2
            },
            city:{
                required:true,
                minlength:2
            },
            email:{
                required:true,
                email: true,
            },
            phone:{
                required:true,
                minlength:2
            },
            address:{
                required:true,
                minlength:2
            },
        },
        messages: {
            name:{
                required:'Por favor introduza o nome da sucursal',
                minlength:'O nome deve ter no mínimo 2 caracteres'
            },
            nuit:{
                required:'Por favor introduza o NUIT da sucursal',
                minlength:'O NUIT deve ter no mínimo 9 caracteres',
                maxlength:'O NUIT deve ter no máximo 9 caracteres',
            },
            country:{
                required:'Por favor introduza o País da sucursal',
                minlength:'O nome deve ter no mínimo 2 caracteres'
            },
            city:{
                required:'Por favor introduza o País da sucursal',
                minlength:'O nome do país deve ter no mínimo 2 caracteres'
            },
            email:{
                required:'Por favor introduza o email da sucursal',
                email:'Email introduzido é invalido',
            },
            phone:{
                required:'Por favor introduza o telefone da sucursal',
            },
            address:{
                required:'Por favor introduza o endereço da sucursal',
            },
        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
          error.addClass('invalid-feedback');
          element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
          $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
          $(element).removeClass('is-invalid');
        }
      });
    });

    $(document).ready(function () {
        $('.select2bs4').select2({
            theme: 'bootstrap4'
        })
    });


    function saveCompanyData(){
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
      });


        let data = $('form#create-brunch-company').serializeArray();

        $.ajax({
            ...ajaxSettings,
            method:'POST',
            url: "<?php echo e(URL::signedRoute('api.company.brunch.store')); ?>",
            data: data,
            beforeSend: function(){
              $('form#create-brunch-company button.save').addClass('d-none');
              $('form#create-brunch-company button.saved').addClass('d-none');
              $('form#create-brunch-company button.error').addClass('d-none');
              $('form#create-brunch-company button.saving').removeClass('d-none');
            },
            statusCode : {
                201: function(response){
                  Toast.fire({
                    type: 'success',
                    title: '<?php echo app('translator')->get("New user has been created"); ?>.'
                  })

                  $('form#create-brunch-company button.save').addClass('d-none');
                  $('form#create-brunch-company button.saved').removeClass('d-none');
                  $('form#create-brunch-company button.saving').addClass('d-none');
                  $('form#create-brunch-company button.error').addClass('d-none');
                    setTimeout(() => {
                        goto(response.url.web);
                    }, 3000)
                },
                401:(response) =>{

                    Toast.fire({
                        type: 'error',
                        title: '<?php echo app('translator')->get("Volte a fazer o login"); ?>.'
                    });

                    $.ajax({
                        url: "<?php echo e(URL::signedRoute('web.system.exit')); ?>",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });

                },
                422:(response) =>{
                  Toast.fire({
                    type: 'error',
                    title: '<?php echo app('translator')->get("Verifique os dados inseridos e submeta outra vez"); ?>.'
                  })
                },
            },
            error: (response) => {
              $('form#create-brunch-company button.save').addClass('d-none');
              $('form#create-brunch-company button.saved').addClass('d-none');
              $('form#create-brunch-company button.saving').addClass('d-none');
              $('form#create-brunch-company button.error').removeClass('d-none');
              setTimeout(() => {
                $('form#create-brunch-company button.save').removeClass('d-none');
                $('form#create-brunch-company button.saved').addClass('d-none');
                $('form#create-brunch-company button.saving').addClass('d-none');
                $('form#create-brunch-company button.error').addClass('d-none');
              }, 2000)
            }
        });
    }
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/company/brunch/create/parts/form.blade.php ENDPATH**/ ?>