<form role="form" class="" id="finalize-delivery_note">
    <div class="row">
        <div class="form-group col-sm-4">
            <label for="gender"><?php echo app('translator')->get('Cliente'); ?></label>
            <select class="selectpicker form-control" data-style="btn-outline-primary" data-size="4" required
                data-live-search="true" name="customer">
                <option>Escolha o cliente</option>

                <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($customer->id); ?>"  data-tokens="<?php echo e($customer->code); ?>"
                    <?php if($customer->deliveryNotes->isNotEmpty()): ?>
                        hasBills=1
                    <?php endif; ?>                 >
                    <?php echo e($customer->name); ?> </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>


        <?php $__env->startPush('js'); ?>
            <script>
                $(() => {
                    $('select[name="customer"]').change(()=>{
                        let result = $('select[name="customer"] option:selected').attr('hasBills')
                        if(result == 1)
                            $('div.pending-alerts').removeClass('d-none')
                        else
                        $('div.pending-alerts').addClass('d-none')

                    })
                });
            </script>
        <?php $__env->stopPush(); ?>

        <div class="form-group col-sm-4">
            <label for="discount"><?php echo app('translator')->get('Desconto'); ?></label>
            <input type="text" name="discount" class="form-control" id="discount" placeholder="1500" value="0">
        </div>

        <div class="form-group col-sm-4">
            <label for="due_date"><?php echo app('translator')->get('Prazo de pagamento'); ?></label>
            <input type="date" name="due_date" class="form-control" id="due_date" placeholder="1500" value="">
        </div>

        <div class="form-group col-sm-12 d-none pending-alerts" >
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?php echo app('translator')->get('Cliente com saldos pendentes'); ?>
              </div>
        </div>

        <div class="form-group col-sm-12">
            <label for="obs"><?php echo app('translator')->get('Observação'); ?></label>
            <textarea class="form-control" rows="2" name="obs" placeholder="Enter ..."></textarea>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <button type="button" class="btn btn-sm btn-outline-primary save "><?php echo app('translator')->get('Finalizar'); ?></button>
            <button type="button" class="btn btn-sm btn-outline-info save-print"><?php echo app('translator')->get('Finalizar e
                Imprimir'); ?></button>
            <button type="button" class="btn btn-sm btn-outline-success d-none saved"><?php echo app('translator')->get('Finalizado'); ?></button>
            <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                    class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i><?php echo app('translator')->get('Finalizando'); ?></button>
            <button type="button" class="btn btn-sm btn-outline-danger d-none error"><?php echo app('translator')->get('Erro'); ?></button>
        </div>
    </div>

</form>

<?php $__env->startPush('js'); ?>
<script type="text/javascript">
    var print = false;
$(document).on('click', 'form#finalize-delivery_note button.save', function (event) {
    print = false;
    finalizeSale()
    event.stopPropagation()
});
$(document).on('click', 'form#finalize-delivery_note button.save-print', function (event) {
    print = true;
    finalizeSale();
    event.stopPropagation()
});

function finalizeSale() {
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
    });
    let data = $('form#finalize-delivery_note').serializeArray();

    $.ajax({
        ...ajaxSettings,
        method: 'PUT',
        url: "<?php echo e(URL::signedRoute('api.sales.delivery_note.update', ['delivery_note'=> $delivery_note->id])); ?>",
        data: data,
        beforeSend: function () {

            $('form#finalize-delivery_note button.save').addClass('d-none');
            $('form#finalize-delivery_note button.saved').addClass('d-none');
            $('form#finalize-delivery_note button.error').addClass('d-none');
            $('form#finalize-delivery_note button.saving').removeClass('d-none');
        },
        statusCode: {
            202: function (response) {
                Toast.fire({
                    type: 'success',
                    title: '<?php echo app('translator')->get("Entradas finalizadas"); ?>.'
                });

                $('form#finalize-delivery_note button.save').addClass('d-none');
                $('form#finalize-delivery_note button.saved').removeClass('d-none');
                $('form#finalize-delivery_note button.saving').addClass('d-none');
                $('form#finalize-delivery_note button.error').addClass('d-none');


                if (print)
                    goto('<?php echo e(URL::signedRoute('web.sales.delivery_note.print', ['delivery_note'=> $delivery_note->id])); ?>')
                else{
                    reload()
                }

            },
            403: () => {
                reload();
            },
            401: (response) => {

                Toast.fire({
                    type: 'error',
                    title: '<?php echo app('translator')->get("Volte a fazer o login"); ?>.'
                })

                $.ajax({
                    url: "<?php echo e(URL::signedRoute('web.system.exit')); ?>",
                    dataType: "HTML",
                    success: function (response) {
                        setTimeout(() => {
                            reload();
                        }, 1500);
                    }
                });
            }
        },
        error: (response) => {
            $('form#finalize-delivery_note button.save').addClass('d-none');
            $('form#finalize-delivery_note button.saved').addClass('d-none');
            $('form#finalize-delivery_note button.saving').addClass('d-none');
            $('form#finalize-delivery_note button.error').removeClass('d-none');
            setTimeout(() => {
                $('form#finalize-delivery_note button.save').removeClass('d-none');
                $('form#finalize-delivery_note button.saved').addClass('d-none');
                $('form#finalize-delivery_note button.saving').addClass('d-none');
                $('form#finalize-delivery_note button.error').addClass('d-none');
            }, 2000)
        }
    });
}
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/sales/delivery_note/create/parts/mini/finalize-btn.blade.php ENDPATH**/ ?>