<form role="form" id="creatte-move">
    <div class="row">

        <div class="form-group col-sm-4">
            <label for="gender"><?php echo app('translator')->get('Produto'); ?></label>
            <select id="saleable" name="saleable" class="selectpicker form-control" data-style="btn-outline-primary" required data-size="4"
                data-live-search="true" name="saleable">
                <?php $__currentLoopData = $saleables; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $saleable): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($saleable->id); ?>" price="<?php echo e($saleable->last_price); ?>"
                    data-tokens="<?php echo e($saleable->code); ?>"> <?php echo e($saleable->name); ?> </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <?php $__env->startPush('js'); ?>
        <script>

            function selectedPrice(){
                let price = $('select#saleable option:selected').attr('price')
                return price
            }
            function s95 (){
                let price = selectedPrice();
                let value = $('input#quantity').val() ? price * $('input#quantity').val() : price;
                $('input#price').val(value);
            }

            $(document).ready(s95);
            $(document).ready(function () {
                $('select#saleable').change(s95);
            });

            $('input#quantity').keyup(function (e) {
                e.preventDefault();
                let price       = selectedPrice()
                let quantity    = $('input#quantity').val()
                $('input#price').val(price*quantity);
            });
        </script>
        <?php $__env->stopPush(); ?>



        <div class="form-group col-sm-4">
            <label for="quantity"><?php echo app('translator')->get('Quantidade'); ?></label>
            <input type="text" name="quantity" class="form-control" id="quantity" placeholder="1">
        </div>

        <div class="form-group col-sm-4">
            <label for="price"><?php echo app('translator')->get('Preço total'); ?></label>
            <input type="text" name="price" class="form-control" id="price" placeholder="1500">
        </div>

        <div class="form-group col-sm-4">
            <label for="expirity_date"><?php echo app('translator')->get('Data de validade'); ?></label>
            <input type="date" name="expirity_date" class="form-control" id="expirity_date">
        </div>

        <div class="form-group col-sm-8">
            <label for="gender"><?php echo app('translator')->get('Armazém de destino'); ?></label>
            <select class="selectpicker form-control" data-live-search="true" data-style="btn-outline-primary" required data-size="4"
                name="warehouse">
                <?php $__currentLoopData = $warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warehouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($warehouse->id); ?>"> <?php echo e($warehouse->name); ?> </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>


    </div>

    <div class="row">
        <div class="col-12">
            <button type="submit" class="btn btn-sm btn-outline-primary save"><?php echo app('translator')->get('Salvar'); ?></button>
            <button type="button" class="btn btn-sm btn-outline-success d-none saved"><?php echo app('translator')->get('Salvo'); ?></button>
            <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                    class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i><?php echo app('translator')->get('Salvando'); ?></button>
            <button type="button" class="btn btn-sm btn-outline-danger d-none error"><?php echo app('translator')->get('Erro'); ?></button>
        </div>
    </div>
</form>


<?php $__env->startSection('plugins.JqueryValidation', true); ?>
<?php $__env->startSection('plugins.Select2', true); ?>
<?php $__env->startSection('plugins.Sweetalert2', true); ?>
<?php $__env->startSection('plugins.SelectPicker', true); ?>

<?php $__env->startPush('js'); ?>
<script type="text/javascript">
    $(document).ready(function () {
    $.validator.setDefaults({
        submitHandler: saveCompanyData
    });

    $('#creatte-move').validate({
        rules: {
            saleable: {
                required: true,
            },
            quantity: {
                required: true,
                min: 0
            },
            price: {
                required: true,
                min: 0
            },
            expirity_date: {
                date: true
            },
            warehouse: {
                required: true,
            },


        },
        messages: {
            saleable: {
                required: 'Campo obrigatório',
            },
            quantity: {
                required: 'Campo obrigatório',
                min: 'Valor introduzido é inválido'
            },
            price: {
                required: 'Campo obrigatório',
                min: 'Valor introduzido é inválido'
            },
            expirity_date: {
                date: 'Introduza uma data valida'
            },
            warehouse: {
                required: 'Campo obrigatório',
            },
        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
            $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
            $(element).removeClass('is-invalid');
        }
    });
});

$(document).ready(function () {
    $('.select2bs4').select2({
        theme: 'bootstrap4'
    })
});


function saveCompanyData() {
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
    });


    let data = $('form#creatte-move').serializeArray();

    $.ajax({
        ...ajaxSettings,
        method: 'POST',
        url: "<?php echo e(URL::signedRoute('api.stock.move.store')); ?>",
        data: data,
        beforeSend: function () {
            $('form#creatte-move button.save').addClass('d-none');
            $('form#creatte-move button.saved').addClass('d-none');
            $('form#creatte-move button.error').addClass('d-none');
            $('form#creatte-move button.saving').removeClass('d-none');
        },
        statusCode: {
            201: function (response) {
                handlebar.init(response.data);
                Toast.fire({
                    type: 'success',
                    title: '<?php echo app('translator')->get("Entrada provisoria guardada"); ?>.'
                });

                $('form#creatte-move button.save').addClass('d-none');
                $('form#creatte-move button.saved').removeClass('d-none');
                $('form#creatte-move button.saving').addClass('d-none');
                $('form#creatte-move button.error').addClass('d-none');
                setTimeout(() => {
                    $('form#creatte-move button.save').removeClass('d-none');
                    $('form#creatte-move button.saved').addClass('d-none');
                    $('form#creatte-move button.saving').addClass('d-none');
                    $('form#creatte-move button.error').addClass('d-none');
                }, 3000);
            },
            401: (response) => {

                Toast.fire({
                    type: 'error',
                    title: '<?php echo app('translator')->get("Volte a fazer o login"); ?>.'
                })

                $.ajax({
                    url: "<?php echo e(URL::signedRoute('web.system.exit')); ?>",
                    dataType: "HTML",
                    success: function (response) {
                        setTimeout(() => {
                            reload();
                        }, 1500);
                    }
                });
            },
            403: () => {
                reload();
            },
            422: (response) => {
                Toast.fire({
                    type: 'error',
                    title: '<?php echo app('translator')->get("Verifique os dados inseridos e submeta outra vez"); ?>.'
                })
            },
        },
        error: (response) => {
            $('form#creatte-move button.save').addClass('d-none');
            $('form#creatte-move button.saved').addClass('d-none');
            $('form#creatte-move button.saving').addClass('d-none');
            $('form#creatte-move button.error').removeClass('d-none');
            setTimeout(() => {
                $('form#creatte-move button.save').removeClass('d-none');
                $('form#creatte-move button.saved').addClass('d-none');
                $('form#creatte-move button.saving').addClass('d-none');
                $('form#creatte-move button.error').addClass('d-none');
            }, 2000)
        }
    });
}


$(document).ready(checkSelectedOption);

$('select[name="saleable"]').change(checkSelectedOption);

function checkSelectedOption() {
    const items = JSON.parse('<?php echo $saleables; ?>')
    const value =  $('select[name="saleable"]').val();

    let searcher = new Searchable(items)

    let saleable = searcher.data(value);
    if (saleable) {
        render(saleable)
    }
}

function render(saleable) {
     //console.log(saleable)
   $('input[name="last_qty"]').attr('value', saleable.code).val( saleable.last_qty);

   $('input[name="last_preco"]').attr('value', saleable.code).val(saleable.price+" MT");
}
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/stock/stockmove/create/parts/mini/form.blade.php ENDPATH**/ ?>