<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title"><?php echo app('translator')->get('Informações da venda'); ?></h3>
                </div>
                <div class="card-body">
                    <form role="form" method="POST" id="generate-report"
                        action="<?php echo e(URL::route('web.sales.report.generate.pdf')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="form-group col-sm-4">
                                <label for="documents"><?php echo app('translator')->get('Documentos a incluir'); ?></label>

                                <select class="selectpicker form-control" multiple data-style="btn-outline-primary"
                                    data-size="8" data-live-search="true" id="documents" name="documents[]"
                                    data-actions-box="true" title="Indique os documentos">
                                    <?php if($company->hasFuncBasic_sale()): ?>
                                    <option value="1" data-tokens=""><?php echo app('translator')->get('Vendas Básicas'); ?></option>
                                    <?php endif; ?>

                                    <?php if($company->hasFuncInvoice()): ?>
                                    <option value="2" data-tokens=""><?php echo app('translator')->get('Faturas'); ?></option>
                                    <?php endif; ?>



                                    <?php if($company->hasFuncRecipt()): ?>
                                    <option value="3" data-tokens=""><?php echo app('translator')->get('Recibos'); ?></option>
                                    <?php endif; ?>

                                    <?php if($company->hasFuncDebit_note()): ?>
                                    <option value="4" data-tokens=""><?php echo app('translator')->get('NC'); ?></option>
                                    <?php endif; ?>

                                    <?php if($company->hasFuncCredit_note()): ?>
                                    <option value="5" data-tokens=""><?php echo app('translator')->get('ND'); ?></option>
                                    <?php endif; ?>

                                    <?php if($company->hasFuncCash_sale()): ?>
                                    <option value="6" data-tokens=""><?php echo app('translator')->get('Venda Dinheiro'); ?></option>
                                    <?php endif; ?>

                                    <?php if($company->hasFuncDelivery_note()): ?>
                                       <option value="7" data-tokens=""><?php echo app('translator')->get('Guia De Remessa'); ?></option>
                                    <?php endif; ?>

                                    <?php if($company->hasFuncInvoice()): ?>
                                    <option value="8" data-tokens=""><?php echo app('translator')->get('Faturas/Guias'); ?></option>
                                    <?php endif; ?>

                                </select>
                            </div>


                            <div class="form-group col-sm-4">
                                <label for="period_from"><?php echo app('translator')->get('Data Inicial'); ?></label>
                                <input type="date" max="<?php echo e(now()); ?>" name="period_from" class="form-control"
                                    id="period_from" placeholder="Data Inicial">
                            </div>

                            <div class="form-group col-sm-4">
                                <label for="period_to"><?php echo app('translator')->get('Data final'); ?></label>
                                <input type="date" max="<?php echo e(now()->endOfMOnth()); ?>" name="period_to" class="form-control"
                                    id="period_to" placeholder="Data final">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <a href="#" target="blank">

                                    <button type="submit"
                                    class="btn btn-sm btn-outline-primary save"><?php echo app('translator')->get('Imprimir'); ?></button>

                                </a>



                                <button type="button"
                                    class="btn btn-sm btn-outline-success d-none saved"><?php echo app('translator')->get('Processado'); ?></button>
                                <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                                        class="fa fa-spinner fa-spin fa-circle-notch"
                                        aria-hidden="true"></i><?php echo app('translator')->get('Processando'); ?></button>
                                <button type="button"
                                    class="btn btn-sm btn-outline-danger d-none error"><?php echo app('translator')->get('Erro'); ?></button>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startSection('plugins.JqueryValidation', true); ?>
<?php $__env->startSection('plugins.BootstrapSwitch', true); ?>
<?php $__env->startSection('plugins.Sweetalert2', true); ?>
<?php $__env->startSection('plugins.SelectPicker', true); ?>
<?php $__env->startPush('js'); ?>
<script type="text/javascript">
    $(document).ready(function () {
    $('#generate-report').validate({
        rules: {
            documents: {
                required: true,
            },
            period_from: {
                required: true,
                date: true,
            },
            period_to: {
                required: true,
                date: true,
            },
        },
        messages: {
            quantity: {
                required: 'Este campo é obrigatório',
                min: 'Deve ser no mínimo zero'
            },
            discount: {
                min: 'Deve ser no mínimo zero'
            },
        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
            $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
            $(element).removeClass('is-invalid');
        }
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/reports/generator/create/parts/form.blade.php ENDPATH**/ ?>