<!DOCTYPE html>
<html>

<head>
    <script type="text/javascript">
        window.print();
        window.onafterprint = back;

        function back() {
            window.history.back();
        }
    </script>

    <style type="text/css">
        @font-face {
            font-family: 'merchant_copy_doublesizeRg';
            font-weight: normal;
            font-style: normal;
        }
    </style>
    <style type="text/css">
        * {
            margin-right: 1px;
            padding: 0px;
            /* font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif */
            font-family: 'merchant_copy_doublesizeRg';
        }


        body {
            font-size: 11px;
        }

        table {
            border: 1px solid #ccc;
            width: 100%;
            text-align: center;
        }

        table tr {
            border: 1px solid #ccc;
        }




        table tfoot td {
            /* border-left: 2px solid; */
            border-top: 2px solid;
        }
    </style>

</head>

<?php
$company = $shift->company;
?>

<body>
    <div style="margin: auto; width: 200px; text-align: center">
        <img src="<?php echo e($company->logoPhoto()); ?>" width="80px" height="80px" style="object-fit: scale-down;"><br>
        <b><?php echo e($company->name); ?></b><br>
        <b>Endereco: </b> <?php echo e($company->address); ?><br>
        <b>Nuit: </b> <?php echo e($company->nuit); ?><br>
        <b>Turno: <?php echo e($shift->id); ?></b><br>
        <b>Usuário:</b> <?php echo e($shift->user->name); ?>

    </div>

    <div style="margin-top: 10px">
        <div style="width: 33%; float: left; text-align: left">
            <b><?php echo app('translator')->get('Abertura'); ?>: </b>
            <?php echo e($shift->openedAt()); ?>

        </div>

        <div style="width: 33%; float: left; text-align: left">
            <b><?php echo app('translator')->get('Encerado'); ?>: </b>
            <?php echo e($shift->closedAt()); ?>

        </div>

        <div style="width: 33%; float: left; text-align: left">
            <b><?php echo app('translator')->get('Duração'); ?>: </b>
            <?php echo e($shift->duration()); ?> Horas
        </div>
    </div>

    <div style="margin-top: 10px">
        <div style="width: 45%; float: left; text-align: left">
            <b><?php echo app('translator')->get('Aberto por'); ?>: </b>
            <?php echo e($shift->user->name); ?>

        </div>

        <div style="width: 45%; float: left; text-align: left">

            <b><?php echo app('translator')->get('Encerado por'); ?>: </b>
            <?php echo e($shift->closedByUser? $shift->closedByUser->name : ''); ?>

        </div>

    </div>

    <div style="margin-top: 20px;">
        <table>
            <thead>
                <tr>
                    <th style=" text-align: left;"><?php echo app('translator')->get('Tipo'); ?></th>
                    <th style=" text-align: right;"><?php echo app('translator')->get('Valor'); ?></th>
                    <th>&nbsp;&nbsp;</th>
                </tr>
            </thead>
            <tbody>
                <?php if($shift->basicSales()->exists()): ?>
                <tr>
                    <td style=" text-align: left;"><?php echo app('translator')->get('Venda Básicas'); ?></td>
                    <td style=" text-align: right;">
                        <?php echo e(number_format($shift->sum($shift->basicSales()->where('validated_at', '<>', null)->get()), 2)); ?>

                        MZN</td>
                    <td>&nbsp;&nbsp;</td>
                </tr>
                <?php endif; ?>

                <?php if($shift->cashSales()->exists()): ?>
                <tr>
                    <td style=" text-align: left;"><?php echo app('translator')->get('Venda dinheiro'); ?></td>
                    <td style=" text-align: right;">
                        <?php echo e(number_format($shift->sum($shift->cashSales()->where('validated_at', '<>', null)->get()), 2)); ?>

                        MZN</td>
                    <td>&nbsp;&nbsp;</td>
                </tr>
                <?php endif; ?>

                <?php if($shift->invoices()->exists()): ?>
                <tr>
                    <td style=" text-align: left;"><?php echo app('translator')->get('Faturas'); ?></td>
                    <td style=" text-align: right;">
                        <?php echo e(number_format($shift->sum($shift->invoices()->where('validated_at', '<>', null)->get()), 2)); ?>

                        MZN</td>
                    <td>&nbsp;&nbsp;</td>
                </tr>
                <?php endif; ?>


                <?php if($shift->invoices()->exists()): ?>
                <tr>
                    <td style=" text-align: left;"><?php echo app('translator')->get('Faturas/Guias'); ?></td>
                    <td style=" text-align: right;">
                        <?php echo e(number_format($shift->sum($shift->invoicesbydelivery()->where('validated_at', '<>', null)->get()), 2)); ?>

                        MZN</td>
                    <td>&nbsp;&nbsp;</td>
                </tr>
                <?php endif; ?>

                <?php if($shift->deliveryNotes()->exists()): ?>
                <tr>
                    <td style=" text-align: left;"><?php echo app('translator')->get('Guias de remessas'); ?></td>
                    <td style=" text-align: right;">
                        <?php echo e(number_format($shift->sum($shift->deliveryNotes()->where('validated_at', '<>', null)->get()), 2)); ?>

                        MZN</td>
                    <td>&nbsp;&nbsp;</td>
                </tr>
                <?php endif; ?>


                <?php if($shift->debitNotes()->exists()): ?>
                <tr>
                    <td style=" text-align: left;"><?php echo app('translator')->get('Notas de débito'); ?></td>
                    <td style=" text-align: right;">
                        <?php echo e(number_format($shift->sum($shift->debitNotes()->where('validated_at', '<>', null)->get()), 2)); ?>

                        MZN</td>
                    <td>&nbsp;&nbsp;</td>
                </tr>
                <?php endif; ?>


                <?php if($shift->creditNotes()->exists()): ?>
                <tr>
                    <td style=" text-align: left;"><?php echo app('translator')->get('Notas de crédito'); ?></td>
                    <td style=" text-align: right;">
                        <?php echo e(number_format($shift->sum($shift->creditNotes()->where('validated_at', '<>', null)->get()), 2)); ?>

                        MZN</td>
                    <td>&nbsp;&nbsp;</td>
                </tr>
                <?php endif; ?>


                <?php if($shift->receipts()->exists()): ?>

                <tr>
                    <td style=" text-align: left;"><?php echo app('translator')->get('Recibos'); ?></td>
                    <td style=" text-align: right;">
                        <?php echo e(number_format($shift->sum($shift->receipts()->where('validated_at', '<>', null)->get()), 2)); ?>

                        MZN</td>
                    <td>&nbsp;&nbsp;</td>
                </tr>
                <?php endif; ?>




            </tbody>

            <tfoot>
                <tr>

                    <td style="text-align: right; font-weight: bold;"><?php echo app('translator')->get('Total de entradas'); ?>: </td>
                    <td colspan="1" style="text-align: right;"><?php echo e(number_format($shift->entries(), 2, ',', ' ')); ?> MZN
                    </td>
                    <td>&nbsp;&nbsp;</td>
                </tr>

                <tr>
                    <td style="text-align: right; font-weight: bold;"><?php echo app('translator')->get('Total de saídas'); ?>: </td>
                    <td colspan="1" style="text-align: right;"><?php echo e(number_format($shift->outputs(), 2, ',', ' ')); ?>

                        MZN</td>
                    <td>&nbsp;&nbsp;</td>
                </tr>
            </tfoot>
        </table>
    </div>


    <div style="margin-top: 20px;">
        <table>
            <thead>
                <tr>
                    <th style=" text-align: left;"><?php echo app('translator')->get('Produto'); ?></th>
                    <th style=" text-align: right;"><?php echo app('translator')->get('Quantidade'); ?></th>
                    <th>&nbsp;&nbsp;</th>
                </tr>
            </thead>
            <tbody>

                <?php $__currentLoopData = $shift->saleables()->sortBy('name'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $saleable): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td style=" text-align: left;"><?php echo e($saleable->name); ?></td>
                    <td style=" text-align: right;">
                        <?php echo e(number_format($saleable->sold_quantity, 2)); ?>

                    </td>
                    <td>&nbsp;&nbsp;</td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </tbody>
        </table>
    </div>

    <?php
    $categories = $shift->categories();
    ?>

    <?php if($categories->isNotEmpty()): ?>
    <div style="margin-top: 20px;">
        <table>
            <thead>
                <tr>
                    <th style=" text-align: left;"><?php echo app('translator')->get('Categoria'); ?></th>
                    <th style=" text-align: right;"><?php echo app('translator')->get('Quantidade Vendida'); ?></th>
                    <th>&nbsp;&nbsp;</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td style=" text-align: left;"><?php echo e($category->name); ?></td>

                    <td style=" text-align: right;">
                        <?php echo e(number_format($category->sold_quantity, 2)); ?>

                    </td>
                    <td>&nbsp;&nbsp;</td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
    <?php endif; ?>

    <div style="margin-top: 5px">
        <div style="width: 100%; float: left; text-align: left">
            <?php echo app('translator')->get('Obrigado'); ?><br /><?php echo app('translator')->get('Volte sempre'); ?>

        </div>
    </div>


    <div style="margin-top: 20px">
        <div style="width: 100%; float: left; text-align: left">
            <?php echo e(config('app.name')); ?> &nbsp; v2.1<br />
            <?php echo app('translator')->get('Operador'); ?>: <i><?php echo e(request()->user()->name); ?></i>
        </div>
    </div>

    <div style="margin-top: 5px">
        <div style="width: 100%; float: left; text-align: right">
            <?php echo app('translator')->get('Assinature'); ?><br /><br><?php echo app('translator')->get('____________________________'); ?>
        </div>
    </div>
</body>
<html>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/shifts/print/thermal/index.blade.php ENDPATH**/ ?>