
  <form role="form" class="" id="delete-customers">
  <div class="row">
    <div class="col-12">

      <a name="" id="" class="btn btn-sm btn-outline-primary"
        href="<?php echo e(URL::route('web.customer.statement', ['customer'=> $customer->id])); ?>" role="button"><?php echo app('translator')->get('Extrato'); ?>
      </a>

<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-local')): ?>
      <button type="submit" class="btn btn-sm btn-outline-danger save"><?php echo app('translator')->get('Apagar'); ?></button>
<?php endif; ?>

      <button type="button" class="btn btn-sm btn-outline-success d-none saved"><?php echo app('translator')->get('Apagado'); ?></button>
      <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
          class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i><?php echo app('translator')->get('Apagando'); ?></button>
      <button type="button" class="btn btn-sm btn-outline-danger d-none error"><?php echo app('translator')->get('Erro'); ?></button>
    </div>
  </div>
</form>








<?php $__env->startPush('js'); ?>
<script type="text/javascript">
  $(document).ready(function () {
      $.validator.setDefaults({
        submitHandler: deleteSaleable
      });

      $('#delete-customers').validate({
        rules: {

        },
        messages: {

        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
          error.addClass('invalid-feedback');
          element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
          $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
          $(element).removeClass('is-invalid');
        }
      });
    });

    function deleteSaleable(){
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
      });


        let data = $('form#delete-customers').serializeArray();

        $.ajax({
            ...ajaxSettings,
            method:'DELETE',
            url: "<?php echo e(URL::signedRoute('api.customer.destroy', ['customer'=>$customer->id])); ?>",
            data: data,
            beforeSend: function(){
              $('form#delete-customers button.save').addClass('d-none');
              $('form#delete-customers button.saved').addClass('d-none');
              $('form#delete-customers button.error').addClass('d-none');
              $('form#delete-customers button.saving').removeClass('d-none');
            },
            statusCode : {
                204: function(response){
                  Toast.fire({
                    type: 'success',
                    title: '<?php echo app('translator')->get("Product has been edited"); ?>.'
                  })

                  $('form#delete-customers button.save').addClass('d-none');
                  $('form#delete-customers button.saved').removeClass('d-none');
                  $('form#delete-customers button.saving').addClass('d-none');
                  $('form#delete-customers button.error').addClass('d-none');
                    setTimeout(() => {
                        goto("<?php echo e(URL::signedRoute('web.customer.index')); ?>");
                    }, 3000)
                },
                401:(response) =>{

                    Toast.fire({
                        type: 'error',
                        title: '<?php echo app('translator')->get("Volte a fazer o login"); ?>.'
                    })

                    $.ajax({
                        url: "<?php echo e(URL::signedRoute('web.system.exit')); ?>",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
                422:(response) =>{
                  Toast.fire({
                    type: 'error',
                    title: '<?php echo app('translator')->get("Verifique os dados inseridos e submeta outra vez"); ?>.'
                  })
                },
            },
            error: (response) => {
              $('form#delete-customers button.save').addClass('d-none');
              $('form#delete-customers button.saved').addClass('d-none');
              $('form#delete-customers button.saving').addClass('d-none');
              $('form#delete-customers button.error').removeClass('d-none');
              setTimeout(() => {
                $('form#delete-customers button.save').removeClass('d-none');
                $('form#delete-customers button.saved').addClass('d-none');
                $('form#delete-customers button.saving').addClass('d-none');
                $('form#delete-customers button.error').addClass('d-none');
              }, 2000)
            }
        });
    }
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/customers/customer/show/parts/mini/delete.blade.php ENDPATH**/ ?>