<section class="col-lg-12 connectedSortable">

    <!-- TABLE: LATEST ORDERS -->
    <div class="card card-default">
        <div class="card-header border-transparent">
            <h3 class="card-title">
                <?php echo app('translator')->get('Guia de remessas'); ?> <span class="reference"></span>
            </h3>

            <div class="card-tools">
                <button type="button" class="btn btn-tool btn-sm daterange" data-toggle="tooltip" title="Date range">
                    <i class="far fa-calendar-alt"></i>
                </button>


                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                    <i class="fas fa-minus"></i>
                </button>
                <button type="button" class="btn btn-tool" data-card-widget="remove">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        </div>
        <!-- /.card-header -->
        <div id="table" class="card-body">

        </div>
    </div>
    <!-- /.card -->
</section>

<?php $__env->startSection('plugins.Handlebars', true); ?>
<?php $__env->startSection('plugins.Datatables', true); ?>
<?php $__env->startSection('plugins.DatatablesExport', true); ?>


<script id="table-template" type="text/x-handlebars-template">
    <table class="sb-datatable export excel table table-bordered table-striped display compact">
        <thead>
            <tr>
                <th><?php echo app('translator')->get('Documento'); ?></th>
                <th><?php echo app('translator')->get('Validade'); ?></th>
                <th><?php echo app('translator')->get('Emissão'); ?></th>
                <th><?php echo app('translator')->get('Cliente'); ?></th>
                <th><?php echo app('translator')->get('Desconto'); ?></th>
                <th><?php echo app('translator')->get('Valor'); ?></th>
                <th><?php echo app('translator')->get('Faturado'); ?></th>
                <th><?php echo app('translator')->get('Recibo'); ?></th>
            </tr>
        </thead>
        <tbody>
        {{#each items }}


            <tr onclick="goto('{{ links.web }}')">
                <td>{{ this.document }}</td>
                <td>{{ this.due_date }}</td>
                <td>{{ this.validated_at }}</td>
                <td>{{ this.customer.name }}</td>
                <td>{{ this.financial_discount }}</td>
                <td>{{ this.total_amount }}</td>
                <td>{{ this.invoiced }}</td>
                <td>{{ this.recipt }}</td>
            </tr>

        {{/each}}

        </tbody>
        <tfoot>
            <tr>
                <th><?php echo app('translator')->get('Documento'); ?></th>
                <th><?php echo app('translator')->get('Validade'); ?></th>
                <th><?php echo app('translator')->get('Emissão'); ?></th>
                <th><?php echo app('translator')->get('Cliente'); ?></th>
                <th><?php echo app('translator')->get('Desconto'); ?></th>
                <th><?php echo app('translator')->get('Valor'); ?></th>
                <th><?php echo app('translator')->get('Faturado'); ?></th>
                <th><?php echo app('translator')->get('Recibo'); ?></th>
            </tr>
        </tfoot>
    </table>
</script>


<?php $__env->startPush('js'); ?>
<script type="text/javascript">
    function renderTable(data){
        handlebar.init(data);
        initDatatable();
    }
    function updateTable(data){
        renderTable(data)
    }

    let handlebar = {
        init: function (list) {
            this.cacheDOM();
            this.render(list);
        },
        cacheDOM: function () {
            this.$tableContainer = $('#table');
        },
        render: function (list) {
            if (list.length) {
                var template = Handlebars.compile($("#table-template").html());
                var context = {
                    'items': list
                };
                var html = template(context);
                this.$tableContainer.html(html);
                this.$tableContainer.parents('.card').show();
            } else {
                this.$tableContainer.parents('.card').hide();
            }
        },
    };

</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/reports/delivery_notes/parts/mini/table.blade.php ENDPATH**/ ?>