<form action="" id="convert-document" class="d-inline">
    <input type="hidden" name="destiny" value="invoice">
    <button type="submit" class="btn btn-sm btn-outline-info save "><?php echo app('translator')->get('Faturar'); ?></button>
    <button type="button" class="btn btn-sm btn-outline-success d-none saved"><?php echo app('translator')->get('Faturado'); ?></button>
    <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
            class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i><?php echo app('translator')->get('Faturando'); ?></button>
    <button type="button" class="btn btn-sm btn-outline-danger d-none error"><?php echo app('translator')->get('Erro'); ?></button>
</form>


<?php $__env->startSection('plugins.JqueryValidation', true); ?>
<?php $__env->startSection('plugins.Sweetalert2', true); ?>

<?php $__env->startPush('js'); ?>
<script type="text/javascript">
    $(document).ready(function () {
          $.validator.setDefaults({
            submitHandler: convertDocument
          });

          $('#convert-document').validate();
        });

        function convertDocument(){

            const Toast = Swal.mixin({
                toast: true,
                position: 'top-end',
                showConfirmButton: false,
                timer: 3000
            });


            let data = $('form#convert-document').serializeArray();
            let invoiceCreate = "<?php echo e(URL::signedRoute('web.sales.invoice.create')); ?>"

            $.ajax({
                ...ajaxSettings,
                method: 'POST',
                url: "<?php echo e(URL::signedRoute('api.sales.proformas.copy', ['proforma' => $proforma->id])); ?>",
                data: data,
                beforeSend: function () {
                    $('form#convert-document button.save').addClass('d-none');
                    $('form#convert-document button.saved').addClass('d-none');
                    $('form#convert-document button.error').addClass('d-none');
                    $('form#convert-document button.saving').removeClass('d-none');
                },
                statusCode: {
                    201: function (response) {
                        Toast.fire({
                            type: 'success',
                            title: '<?php echo app('translator')->get("Document copied"); ?>.'
                        })

                        $('form#convert-document button.save').addClass('d-none');
                        $('form#convert-document button.saved').removeClass('d-none');
                        $('form#convert-document button.saving').addClass('d-none');
                        $('form#convert-document button.error').addClass('d-none');
                        setTimeout(() => {
                            goto(invoiceCreate);
                        }, 3000)
                    },
                    401: (response) => {

                        Toast.fire({
                            type: 'error',
                            title: '<?php echo app('translator')->get("Volte a fazer o login"); ?>.'
                        })

                        $.ajax({
                            url: "<?php echo e(URL::signedRoute('web.system.exit')); ?>",
                            dataType: "HTML",
                            success: function (response) {
                                setTimeout(() => {
                                    reload();
                                }, 1500);
                            }
                        });
                    },
                    422: (response) => {
                        Toast.fire({
                            type: 'error',
                            title: '<?php echo app('translator')->get("Verifique os dados inseridos e submeta outra vez"); ?>.'
                        })
                    },
                },
                error: (response) => {
                    $('form#convert-document button.save').addClass('d-none');
                    $('form#convert-document button.saved').addClass('d-none');
                    $('form#convert-document button.saving').addClass('d-none');
                    $('form#convert-document button.error').removeClass('d-none');
                    setTimeout(() => {
                        $('form#convert-document button.save').removeClass('d-none');
                        $('form#convert-document button.saved').addClass('d-none');
                        $('form#convert-document button.saving').addClass('d-none');
                        $('form#convert-document button.error').addClass('d-none');
                    }, 2000)
                }
            });
        }
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/sales/proforma/show/parts/mini/convert-to-invoice.blade.php ENDPATH**/ ?>