<form role="form" class="" id="finalize-basic">
    <div class="row">
        <?php if($crm): ?>
        <div class="form-group col-sm-4 d-none">
            <label for="customer"><?php echo app('translator')->get('Cliente'); ?></label>
            <input type="text" name="customer" class="form-control" id="customer" placeholder="1500" value="">
        </div>

        <div class="form-group col-sm-4">
            <label for="pay_crm"><?php echo app('translator')->get('Pagar com CRM'); ?></label>
            <br>
            <input type="checkbox" class="bootstrap-switch form-control" name="pay_crm" data-bootstrap-switch
                data-off-color="danger" data-on-color="success" data-off-text="<?php echo app('translator')->get('Não'); ?>"
                data-on-text="<?php echo app('translator')->get('Sim'); ?>">
        </div>
        <?php endif; ?>

        <div class="form-group col-sm-2">
            <label for="total"><?php echo app('translator')->get('Total'); ?></label>
            <input type="text" name="total" disabled class="form-control" id="total" placeholder="1500" value="">
        </div>

        <div class="form-group col-sm-4">
            <label for="paid"><?php echo app('translator')->get('Pago'); ?></label>
            <input type="text" name="paid" class="form-control" id="paid" placeholder="1500" value="0">
        </div>

        <div class="form-group col-sm-2">
            <label for="exchange"><?php echo app('translator')->get('Troco'); ?></label>
            <input type="text" disabled name="exchange" class="form-control" id="exchange" placeholder="0" value="">
        </div>
    </div>


    <button type="button" class="btn btn-sm btn-outline-primary save "><?php echo app('translator')->get('Finalizar'); ?></button>
    <button type="button" class="btn btn-sm btn-outline-info save-print"><?php echo app('translator')->get('Finalizar e Imprimir'); ?></button>
    <button type="button" class="btn btn-sm btn-outline-success d-none saved"><?php echo app('translator')->get('Finalizado'); ?></button>
    <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
            class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i><?php echo app('translator')->get('Finalizando'); ?></button>
    <button type="button" class="btn btn-sm btn-outline-danger d-none error"><?php echo app('translator')->get('Erro'); ?></button>
</form>

<?php $__env->startPush('js'); ?>
<script type="text/javascript">
    $('form#finalize-basic input[name="paid"]').on('keyup', function(){
        $('input[name="exchange"]').val(parseFloat($('form#finalize-basic input[name="paid"]').val()) - parseFloat(coast));
    });
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
<script type="text/javascript">
    var print = false;
    $(document).on('click', 'form#finalize-basic button.save', function (event) {
        print = false;
        finalizeSale()
        event.stopPropagation()
    });
    $(document).on('click', 'form#finalize-basic button.save-print', function (event) {
        print = true;
        finalizeSale();
        event.stopPropagation()
    });

    function finalizeSale() {
        const Toast = Swal.mixin({
            toast: true,
            position: 'top-end',
            showConfirmButton: false,
            timer: 3000
        });
        let data = $('form#finalize-basic').serializeArray();

        $.ajax({
            ...ajaxSettings,
            method: 'PUT',
            url: "<?php echo e(URL::signedRoute('api.sales.basic.update', ['basic'=> $basic->id])); ?>",
            data: data,
            beforeSend: function () {

                $('form#finalize-basic button.save').addClass('d-none');
                $('form#finalize-basic button.saved').addClass('d-none');
                $('form#finalize-basic button.error').addClass('d-none');
                $('form#finalize-basic button.saving').removeClass('d-none');
            },
            statusCode: {
                202: function (response) {
                    Toast.fire({
                        type: 'success',
                        title: '<?php echo app('translator')->get("Entradas finalizadas"); ?>.'
                    });

                    $('form#finalize-basic button.save').addClass('d-none');
                    $('form#finalize-basic button.saved').removeClass('d-none');
                    $('form#finalize-basic button.saving').addClass('d-none');
                    $('form#finalize-basic button.error').addClass('d-none');


                    if (print)
                        goto('<?php echo e(URL::signedRoute('web.sales.basic.print', ['basic'=> $basic->id])); ?>')
                    else{
                        reload()
                    }

                },
                403: () => {
                    // reload();
                },
                401: (response) => {

                    Toast.fire({
                        type: 'error',
                        title: '<?php echo app('translator')->get("Volte a fazer o login"); ?>.'
                    })

                    $.ajax({
                        url: "<?php echo e(URL::signedRoute('web.system.exit')); ?>",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
                422:(response) =>{
                  Toast.fire({
                    type: 'error',
                    title: '<?php echo app('translator')->get("Verifique os dados inseridos e submeta outra vez"); ?>.'
                  })
                },
            },
            // error: (response) => {
            //     $('form#finalize-basic button.save').addClass('d-none');
            //     $('form#finalize-basic button.saved').addClass('d-none');
            //     $('form#finalize-basic button.saving').addClass('d-none');
            //     $('form#finalize-basic button.error').removeClass('d-none');
            //     setTimeout(() => {
            //         $('form#finalize-basic button.save').removeClass('d-none');
            //         $('form#finalize-basic button.saved').addClass('d-none');
            //         $('form#finalize-basic button.saving').addClass('d-none');
            //         $('form#finalize-basic button.error').addClass('d-none');
            //     }, 2000)
            // }
        });
    }
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/sales/basic/create/common/finalize-btn.blade.php ENDPATH**/ ?>