<form role="form" class="mb-3" id="finalize-receipt">
    <input type="hidden" name="amount" value="0">
    <div class="row">
        <div class="form-group col-md-4">
            <label for="gender"><?php echo app('translator')->get('Metodo de pagamento'); ?></label>
            <select class="selectpicker form-control" data-style="btn-outline-primary" data-size="6"
                data-live-search="false" name="payment_method">
                <?php $__currentLoopData = $paymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($payment->id); ?>" data-tokens="<?php echo e($payment->id); ?>">
                    <?php echo e($payment->name); ?> </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="form-group col-sm-4">
            <label for="bank_name"><?php echo app('translator')->get('Nome do Banco'); ?></label>
            <input type="text" name="bank_name" class="form-control" id="bank_name" placeholder="BCI" value="">
        </div>
        <div class="form-group col-sm-4">
            <label for="bank_document_nr"><?php echo app('translator')->get('Número do Documento'); ?></label>
            <input type="text" name="bank_document_nr" class="form-control" id="bank_document_nr" placeholder="BCI0001"
                value="">
        </div>

        <div class="form-group col-sm-12">
            <label for="bank_document_nr"><?php echo app('translator')->get('Observação'); ?></label>
            <textarea class="form-control" rows="2" name="obs" placeholder="Enter ..."></textarea>
        </div>
    </div>


    <div class="row">
        <div class="col-lg-12">
            <button type="button" class="btn btn-sm btn-outline-primary save "><?php echo app('translator')->get('Finalizar'); ?></button>
            <button type="button" class="btn btn-sm btn-outline-info save-print"><?php echo app('translator')->get('Finalizar e Imprimir'); ?></button>
            <button type="button" class="btn btn-sm btn-outline-success d-none saved"><?php echo app('translator')->get('Finalizado'); ?></button>
            <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                    class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i><?php echo app('translator')->get('Finalizando'); ?></button>
            <button type="button" class="btn btn-sm btn-outline-danger d-none error"><?php echo app('translator')->get('Erro'); ?></button>

        </div>
    </div>
</form>

<?php $__env->startPush('js'); ?>
<script type="text/javascript">
    var print = false;
$(document).on('click', 'form#finalize-receipt button.save', function (event) {
    print = false;
    finalizeSale()
    event.stopPropagation()
});
$(document).on('click', 'form#finalize-receipt button.save-print', function (event) {
    print = true;
    finalizeSale();
    event.stopPropagation()
});


function finalizeSale() {
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
    });

    let data = $('form#finalize-receipt').serializeArray()

    let docs = documents.map(item =>{
        return {
            name: 'items[]',
            value: item.hash
        }
    })
    data = $.merge( docs, data )

    $.ajax({
        ...ajaxSettings,
        method: 'PUT',
        url: "<?php echo e(URL::signedRoute('api.sales.recipt.update', ['recipt'=> $recipt->id])); ?>",
        data: data,
        beforeSend: function () {

            $('form#finalize-receipt button.save').addClass('d-none');
            $('form#finalize-receipt button.saved').addClass('d-none');
            $('form#finalize-receipt button.error').addClass('d-none');
            $('form#finalize-receipt button.saving').removeClass('d-none');
        },
        statusCode: {
            202: function (response) {
                Toast.fire({
                    type: 'success',
                    title: '<?php echo app('translator')->get("Entradas finalizadas"); ?>.'
                });

                $('form#finalize-receipt button.save').addClass('d-none');
                $('form#finalize-receipt button.saved').removeClass('d-none');
                $('form#finalize-receipt button.saving').addClass('d-none');
                $('form#finalize-receipt button.error').addClass('d-none');


                if (print) {
                    goto('<?php echo e(URL::signedRoute('web.sales.recipt.print', ['recipt'=> $recipt->id])); ?>')
                }  else{
                    reload()
                }

            },
            403: () => {
                reload();
            },
            401: (response) => {

                Toast.fire({
                    type: 'error',
                    title: '<?php echo app('translator')->get("Volte a fazer o login"); ?>.'
                })

                $.ajax({
                    url: "<?php echo e(URL::signedRoute('web.system.exit')); ?>",
                    dataType: "HTML",
                    success: function (response) {
                        setTimeout(() => {
                            reload();
                        }, 1500);
                    }
                });
            },
            422:(response) =>{
                let message = response.responseJSON.message
                Toast.fire({
                    type: 'error',
                    title: message,

                })
            },
        },
        error: (response) => {
            $('form#finalize-receipt button.save').addClass('d-none');
            $('form#finalize-receipt button.saved').addClass('d-none');
            $('form#finalize-receipt button.saving').addClass('d-none');
            $('form#finalize-receipt button.error').removeClass('d-none');
            setTimeout(() => {
                $('form#finalize-receipt button.save').removeClass('d-none');
                $('form#finalize-receipt button.saved').addClass('d-none');
                $('form#finalize-receipt button.saving').addClass('d-none');
                $('form#finalize-receipt button.error').addClass('d-none');
            }, 2000)
        }
    });
}
</script>
<?php $__env->stopPush(); ?><?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/sales/receipt/create/parts/mini/finalize-btn.blade.php ENDPATH**/ ?>