<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <?php echo app('translator')->get('Finalizar recibo'); ?>
        </h3>
    </div>
    <div class="card-body">
        <?php echo $__env->make('sales.receipt.create.parts.mini.finalize-btn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div id="table"></div>
    </div>
</div>

<?php $__env->startSection('plugins.Handlebars', true); ?>
<script id="table-template" type="text/x-handlebars-template">
    <table  class="table table-sm table-bordered table-hover">
            <thead>
                <tr>
                    <th><?php echo app('translator')->get('Documento'); ?></th>
                    <th><?php echo app('translator')->get('Tipo'); ?></th>
                    <th><?php echo app('translator')->get('Valor Pendente'); ?></th>
                    <th><?php echo app('translator')->get('Valor Total'); ?></th>
                    <th><?php echo app('translator')->get('Apagar'); ?></th>
                </tr>
            </thead>
            <tbody>
            {{#each items }}
                <tr>
                    <td>{{ this.name }}</td>
                    <td>{{ this.type }}</td>
                    <td>{{ this.pending }}</td>
                    <td>{{ this.amount }}</td>

                    <td><button type="button" class="btn btn-outline-danger btn-sm delete" onclick="remove('{{ this.id }}')">
                        <span class="badge" ><i class="fa fa-trash"></i></span>
                    </button></td>
                </tr>
            {{/each}}

            </tbody>
            <tfoot>
                    <tr>
                        <td colspan="4" class="text-right"><?php echo app('translator')->get('Total'); ?></td>
                        <td class="total"></td>
                    </tr>
            </tfoot>
        </table>
</script>
<?php $__env->startPush('js'); ?>

<script type="text/javascript">
    var documents = null;
    $(document).ready(loadItems);

    function loadItems(){
        handlebar.init([]);
    }

    function remove(id){
        documents = documents.filter((item) => {
            return item.id != id
        });
        handlebar.init(documents);
    }

    let handlebar = {
        init: function (list) {
            this.cacheDOM();
            this.render(list);
        },
        cacheDOM: function () {
            this.$tableContainer = $('#table');
        },
        render: function (list) {
            if (list.length) {
                var template = Handlebars.compile($("#table-template").html());
                var context = {
                    'items': list
                };
                var html = template(context);
                this.$tableContainer.html(html);
                this.$tableContainer.parents('.card').show();

                let total = 0
                list.forEach(element => {
                    total = total+ element.pending_unformated
                });
                $('td.total').html(total.toFixed(2));
            } else {
                this.$tableContainer.parents('.card').hide();
            }
        },
    };

</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/sales/receipt/create/parts/handlebars.blade.php ENDPATH**/ ?>