<?php $__env->startSection('plugins.Datatables', true); ?>
<?php $__env->startSection('js'); ?>
<script type="text/javascript">
    $(document).ready(function () {
        initDatatable();
    });
</script>
<?php $__env->stopSection(); ?>


<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <a href="<?php echo e(URL::signedRoute('web.company.brunch.create')); ?>" class="btn btn-sm btn-outline-primary"><?php echo app('translator')->get('Criar nova'); ?></a>
        </h3>
    </div>
    <!-- /.card-header -->
    <div class="card-body">
        <table id="table" class="sb-datatable table table-bordered table-striped display compact">
            <thead>
                <tr>
                    <th><?php echo app('translator')->get('Nome'); ?></th>
                    <th><?php echo app('translator')->get('Pais'); ?></th>
                    <th><?php echo app('translator')->get('Cidade'); ?></th>
                    <th><?php echo app('translator')->get('Telefone'); ?></th>
                    <th><?php echo app('translator')->get('Regime de IVA'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brunch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr ondblclick="goto('<?php echo e(URL::signedRoute('web.company.brunch.show', ['brunch'=>$brunch->id])); ?>')" class="cursor-pointer">
                    <td><?php echo e($brunch->name); ?></td>
                    <td><?php echo e($brunch->country); ?></td>
                    <td><?php echo e($brunch->city); ?></td>
                    <td><?php echo e($brunch->phone); ?></td>
                    <td><?php echo e($brunch->vatScheme->name); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </tbody>
            <tfoot>
                <tr>
                    <th><?php echo app('translator')->get('Nome'); ?></th>
                    <th><?php echo app('translator')->get('Pais'); ?></th>
                    <th><?php echo app('translator')->get('Cidade'); ?></th>
                    <th><?php echo app('translator')->get('Telefone'); ?></th>
                    <th><?php echo app('translator')->get('Regime de IVA'); ?></th>
                </tr>
            </tfoot>
        </table>
    </div>
    <!-- /.card-body -->
</div><?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/company/brunch/list/parts/table.blade.php ENDPATH**/ ?>