<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <?php echo $__env->make('reports.generator.pdf.style', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <style>
        .page-break {
            page-break-after: always;
        }

       @media  print {
            .new-page {
                page-break-before: always;
            }
        }
    </style>
</head>

<body style="font-size: 13px;">

    <div class="container-fluid">
        <div class="float-left w-60 text-left">

            <img src="<?php echo e($company->logoPhoto()); ?>" width="150" style="object-fit: scale-down;" />

            <br><b><?php echo e($company->name); ?></b><br>
            <b><?php echo e($company->nuit); ?></b> <br>
            <?php echo e($company->address); ?><br>
            <?php echo e($company->email); ?><br>
            <?php echo e($company->phone); ?>

            <br>
        </div>

        <div class="float-right w-40 text-right">
            <table class="table table-sm">
                <tbody>
                    <tr>
                        <td colspan="2" class="border-0 text-center"><b><?php echo app('translator')->get('Relatorio de vendas'); ?>: </b></td>
                    </tr>
                    <tr class="border-0 ">
                        <td class="border-0 text-left text-bold"><?php echo app('translator')->get('Início'); ?></td>
                        <td class="border-0 text-right"><?php echo e($from->format('d-m-Y')); ?></td>
                    </tr>
                    <tr class="border-0 ">
                        <td class="border-0 text-left text-bold"><?php echo app('translator')->get('Fim'); ?></td>
                        <td class="border-0 text-right"><?php echo e($to->format('d-m-Y')); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>


    <div class="container-fluid" style="margin-top: 68px;">

        <div class="table-responsive mt-3">
            <br>
             <br> <br> <br> <br> <br>  <br> <br>
            <table class="table table-sm table-body table-bordered mb-1 mt-10">
                <thead class="">
                    <tr>
                        <th class="text-left text-bold"><?php echo app('translator')->get('Tipos de Documentos'); ?></th>
                        <th class="text-right text-bold"><?php echo app('translator')->get('Valor'); ?></th>
                    </tr>
                </thead>
                <tbody>

                    <?php if($includeBasicSales): ?>
                    <tr>
                        <td class="text-left">Venda básica</td>
                        <td class="text-right"><?php echo e(number_format($basicsAmount, 2)); ?></td>
                    </tr>
                    <?php endif; ?>

                    <?php if($includeCashSales): ?>
                    <tr>
                        <td class="text-left"><?php echo app('translator')->get('Venda dinheiro'); ?></td>
                        <td class="text-right"><?php echo e(number_format( $cashSalesAmount, 2)); ?></td>
                    </tr>
                    <?php endif; ?>

                    <?php if($includeInvoices || $includeInvoicebydelivery): ?>

                    <?php if($includeReceipts): ?>
                            <tr>
                                <td class="text-left"><?php echo app('translator')->get('Facturas'); ?></td>
                                <td class="text-right"><?php echo e(number_format(($invoicesAmount-$receiptsAmount)+$invoiceBydeliveryAmount, 2)); ?></td>
                            </tr>
                        <?php else: ?>

                        <tr>
                            <td class="text-left"><?php echo app('translator')->get('Facturas'); ?></td>
                            <td class="text-right"><?php echo e(number_format($invoicesAmount+$invoiceBydeliveryAmount, 2)); ?></td>
                        </tr>

                    <?php endif; ?>

                    <?php endif; ?>

                    

                    <?php if($includeReceipts): ?>
                    <tr>
                        <td class="text-left"><?php echo app('translator')->get('Recibos'); ?></td>
                        <td class="text-right"><?php echo e(number_format($receiptsAmount, 2)); ?></td>
                    </tr>
                    <?php endif; ?>

                    <?php if($includeDelivery): ?>
                    <tr>
                        <td class="text-left"><?php echo app('translator')->get('Guias de Remessas'); ?></td>
                        <td class="text-right"><?php echo e(number_format($deliveryAmount-$invoiceBydeliveryAmount, 2)); ?></td>
                    </tr>
                    <?php endif; ?>

                    <tr class="bg-green">

                        <td style="text-align: right; font-weight: bold;"><?php echo app('translator')->get('Total de entradas'); ?>: </td>
                        <td colspan="1" style="text-align: right; font-weight: bold; color:white;"><?php echo e(number_format($basicsAmount+$cashSalesAmount+$receiptsAmount, 2, ',', ' ')); ?> MZN
                        </td>

                    </tr>

                    <tr class="bg-red">
                        <td  style="text-align: right; font-weight: bold; color:white"><?php echo app('translator')->get('Total de saídas'); ?>: </td>

                        <?php if($includeReceipts): ?>

                                <td class="text-right"><?php echo e(number_format((($invoicesAmount+$invoiceBydeliveryAmount)-$receiptsAmount)+($deliveryAmount-$invoiceBydeliveryAmount), 2, ',', ' ')); ?> MZN</td>
                        <?php else: ?>
                                <td class="text-right"><?php echo e(number_format(($deliveryAmount-$invoiceBydeliveryAmount)+$invoicesAmount+$invoiceBydeliveryAmount, 2, ',', ' ')); ?> MZN</td>
                         <?php endif; ?>
                    </tr>
                </tbody>

            </table>


            <table class="mt-3" style="display: none">
                <tr>
                    <td><sub><?php echo e(config("app.name")); ?>, <?php echo app('translator')->get('Licença'); ?>
                            <span class="text-bold text-sm"><?php echo e(config("app.finance_dep_global_auth")); ?></span> /
                            <?php echo e(Auth::user()->brunch->daf_auth); ?> </sub></td>
                </tr>
            </table>

            <div style="margin-top: 18px; margin-bottom: 20px;">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th style=" text-align: left;"><?php echo app('translator')->get('Código'); ?></th>
                                    <th style=" text-align: left;"><?php echo app('translator')->get('Produto'); ?></th>
                                    <th style=" text-align: center;"><?php echo app('translator')->get('Preço'); ?></th>
                                    <th style=" text-align: center;"><?php echo app('translator')->get('Qty'); ?></th>
                                    <th style=" text-align: center;"><?php echo app('translator')->get('Total (Mzn)'); ?></th>
                                    <th style=" text-align: center;"><?php echo app('translator')->get('Estoque'); ?></th>
                                    <th>&nbsp;&nbsp;</th>
                                </tr>
                            </thead>
                            <tbody>

                                <?php $__currentLoopData = $allItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $saleable): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td style=" text-align: left;"><?php echo e($saleable->sale_code); ?></td>
                                            <td style=" text-align: left;"><?php echo e($saleable->sale_name); ?></td>
                                            <td style=" text-align: center;"><?php echo e(number_format($saleable->unit_amount, 2)); ?></td>

                                            <td style=" text-align: center;">
                                                <?php echo e(number_format($saleable->quantity)); ?>

                                            </td>
                                            <td style=" text-align: center;"><?php echo e(number_format($saleable->total, 2)); ?></td>
                                            <td style=" text-align: center;"><?php echo e(number_format(Auth::user()->company->getLastStock($saleable->saleable_id, $from, $to))); ?></td>
                                            <td>&nbsp;&nbsp;</td>
                                        </tr>


                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>

                        </table>
            </div>
        </div>
    </div>


    <div class="container-fluid">

        <table class="" width="100%">
            <tr>
                 <td width="30%"
                    style="border-top: 1px solid #000000; font-size: 9pt; text-align: left; padding-top: 3mm; ">
                    <span class="d-none"> <?php echo app('translator')->get('Pagina'); ?> . ' {PAGENO} ' .<?php echo app('translator')->get('de'); ?> . ' {nb}</span>

                    <i><?php echo e(config('app.name')); ?>, <?php echo app('translator')->get('Licenciado a'); ?> <strong><?php echo e($company->name); ?></strong></i>

                    <br>
                    <sub> <?php echo e(config("app.finance_dep_global_auth")); ?>

                    </sub>
                    <br>
                    <sub><?php echo app('translator')->get('Processado por computador'); ?></sub>
                </td>

                <td width="40%" class="text-right">
                    &nbsp;
                </td>

                <td width="30%"
                    style="border-top: 1px solid #000000; font-size: 9pt; padding-top: 3mm;  text-align: right;">
                    <?php echo app('translator')->get('Impresso por'); ?>: <?php echo e(Auth::user()->name); ?><br><span
                        style="font-size: 7pt;"><?php echo e(now()->format('d/m/Y')); ?></span>
                </td>
            </tr>
        </table>
    </div>

</body>

</html>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/reports/generator/pdf/index.blade.php ENDPATH**/ ?>