<form role="form" id="edit-category">
  <div class="row">
    <div class="form-group col-sm-4">
      <label for="name"><?php echo app('translator')->get('Nome'); ?></label>
      <input type="text" name="name" class="form-control" id="name" value="<?php echo e($category->name); ?>" placeholder="Total Fuels">
    </div>

    <div class="form-group col-sm-8">
      <label for="description"><?php echo app('translator')->get('Descrição'); ?></label>
      <input type="text" name="description" class="form-control" id="description" value="<?php echo e($category->description); ?>" placeholder="">
    </div>
  </div>
  <div class="row">
    <div class="col-12">
      <button type="submit" class="btn btn-sm btn-outline-primary save"><?php echo app('translator')->get('Salvar'); ?></button>
      <button type="button" class="btn btn-sm btn-outline-success d-none saved"><?php echo app('translator')->get('Salvo'); ?></button>
      <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
          class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i><?php echo app('translator')->get('Salvando'); ?></button>
      <button type="button" class="btn btn-sm btn-outline-danger d-none error"><?php echo app('translator')->get('Erro'); ?></button>
    </div>
  </div>
</form>


<?php $__env->startSection('plugins.JqueryValidation', true); ?>
<?php $__env->startSection('plugins.BootstrapSwitch', true); ?>
<?php $__env->startSection('plugins.Sweetalert2', true); ?>
<?php $__env->startPush('js'); ?>
<script type="text/javascript">
  $(document).ready(function () {
      $.validator.setDefaults({
        submitHandler: saveCompanyData
      });

      $('#edit-category').validate({
        rules: {
            name:{
                required:true,
                minlength:2
            },
            contact:{
                required:true,
            },
        },
        messages: {
            name:{
                required:'Por favor introduza o nome do item',
                minlength:'O nome deve ter no mínimo 2 caracteres'
            },
            contact:{
                required:'Introduza o codigo do produto',
            },
        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
          error.addClass('invalid-feedback');
          element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
          $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
          $(element).removeClass('is-invalid');
        }
      });
    });




    function saveCompanyData(){
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
      });



        let data = $('form#edit-category').serializeArray();

        $.ajax({
            ...ajaxSettings,
            method:'PUT',
            url: "<?php echo e(URL::signedRoute('api.stock.category.update', ['category' => $category->id])); ?>",
            data: data,
            beforeSend: function(){
              $('form#edit-category button.save').addClass('d-none');
              $('form#edit-category button.saved').addClass('d-none');
              $('form#edit-category button.error').addClass('d-none');
              $('form#edit-category button.saving').removeClass('d-none');
            },
            statusCode : {
                202: function(response){
                  Toast.fire({
                    type: 'success',
                    title: '<?php echo app('translator')->get("category has been updates"); ?>.'
                  })

                  $('form#edit-category button.save').addClass('d-none');
                  $('form#edit-category button.saved').removeClass('d-none');
                  $('form#edit-category button.saving').addClass('d-none');
                  $('form#edit-category button.error').addClass('d-none');
                    setTimeout(() => {
                        goto(response.url.web);
                    }, 3000)
                },
                401:(response) =>{

                    Toast.fire({
                        type: 'error',
                        title: '<?php echo app('translator')->get("Volte a fazer o login"); ?>.'
                    })

                    $.ajax({
                        url: "<?php echo e(URL::signedRoute('web.system.exit')); ?>",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
                422:(response) =>{
                  Toast.fire({
                    type: 'error',
                    title: '<?php echo app('translator')->get("Verifique os dados inseridos e submeta outra vez"); ?>.'
                  })
                },
            },
            error: (response) => {
              $('form#edit-category button.save').addClass('d-none');
              $('form#edit-category button.saved').addClass('d-none');
              $('form#edit-category button.saving').addClass('d-none');
              $('form#edit-category button.error').removeClass('d-none');
              setTimeout(() => {
                $('form#edit-category button.save').removeClass('d-none');
                $('form#edit-category button.saved').addClass('d-none');
                $('form#edit-category button.saving').addClass('d-none');
                $('form#edit-category button.error').addClass('d-none');
              }, 2000)
            }
        });
    }
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/stock/category/show/parts/mini/edit.blade.php ENDPATH**/ ?>