<form role="form" class="m-2" id="basic-sale-config">

  <div class="row">
    <div class="form-group col-sm-4">
      <label for="sale_type"><?php echo app('translator')->get('Tipo de venda'); ?></label>
      <select name="sale_type" class="form-control select2bs4" style="width: 100%;"
        data-placeholder="<?php echo app('translator')->get('Tipo de venda na area simples'); ?>">
        <option value="fast"><?php echo app('translator')->get('Rapido'); ?></option>
        <option value="normal" <?php if($sale_config): ?> <?php if(!$sale_config->fast_sale): ?>
          selected
          <?php endif; ?> <?php endif; ?>><?php echo app('translator')->get('normal'); ?></option>
      </select>
    </div>
  </div>



  <div class="row">
    <div class="form-group col-12">
      <!-- /.card-body -->
      <button type="submit" class="btn btn-sm btn-outline-primary save"><?php echo app('translator')->get('Salvar'); ?></button>
      <button type="button" class="btn btn-sm btn-outline-success d-none saved"><?php echo app('translator')->get('Salvo'); ?></button>
      <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
          class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i><?php echo app('translator')->get('Salvando'); ?></button>
      <button type="button" class="btn btn-sm btn-outline-danger d-none error"><?php echo app('translator')->get('Erro'); ?></button>
    </div>
  </div>
</form>

<?php $__env->startPush('js'); ?>
<script type="text/javascript">
  $(document).ready(function () {
      $.validator.setDefaults({
        submitHandler: basicsaleconfig
      });
      $('#basic-sale-config').validate({
        rules: {

        },
        messages: {
            name:{
                required:'Por favor introduza o nome da sucursal',
                minlength:'O nome deve ter no mínimo 2 caracteres'
            },
            nuit:{
                required:'Por favor introduza o NUIT da sucursal',
                minlength:'O NUIT deve ter no mínimo 9 caracteres',
                maxlength:'O NUIT deve ter no máximo 9 caracteres',
            },
            country:{
                required:'Por favor introduza o País da sucursal',
                minlength:'O nome deve ter no mínimo 2 caracteres'
            },
            city:{
                required:'Por favor introduza o País da sucursal',
                minlength:'O nome do país deve ter no mínimo 2 caracteres'
            },
            email:{
                required:'Por favor introduza o email da sucursal',
                email:'Email introduzido é invalido',
            },
            phone:{
                required:'Por favor introduza o telefone da sucursal',
            },
            address:{
                required:'Por favor introduza o endereço da sucursal',
            },
        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
          error.addClass('invalid-feedback');
          element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
          $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
          $(element).removeClass('is-invalid');
        }
      });
    });

    $(document).ready(function () {
        $('.select2bs4').select2({
            theme: 'bootstrap4'
        })
    });


    function basicsaleconfig(){
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
      });


        let data = $('form#basic-sale-config').serializeArray();


        $.ajax({
            ...ajaxSettings,
            method:'POST',
            url: "<?php echo e(URL::signedRoute('api.company.brunch.configuration.store', ['brunch'=> $brunch->id])); ?>",
            data: data,
            beforeSend: function(){
              $('form#basic-sale-config button.save').addClass('d-none');
              $('form#basic-sale-config button.saved').addClass('d-none');
              $('form#basic-sale-config button.error').addClass('d-none');
              $('form#basic-sale-config button.saving').removeClass('d-none');
            },
            statusCode : {
                201: function(response){
                  Toast.fire({
                    type: 'success',
                    title: '<?php echo app('translator')->get("New user has been created"); ?>.'
                  })

                  $('form#basic-sale-config button.save').addClass('d-none');
                  $('form#basic-sale-config button.saved').removeClass('d-none');
                  $('form#basic-sale-config button.saving').addClass('d-none');
                  $('form#basic-sale-config button.error').addClass('d-none');
                    setTimeout(() => {
                        $('form#basic-sale-config button.save').removeClass('d-none');
                $('form#basic-sale-config button.saved').addClass('d-none');
                $('form#basic-sale-config button.saving').addClass('d-none');
                $('form#basic-sale-config button.error').addClass('d-none');
                    }, 3000)
                },
                401:(response) =>{

                    Toast.fire({
                        type: 'error',
                        title: '<?php echo app('translator')->get("Volte a fazer o login"); ?>.'
                    });

                    $.ajax({
                        url: "<?php echo e(URL::signedRoute('web.system.exit')); ?>",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });

                },
                422:(response) =>{
                  Toast.fire({
                    type: 'error',
                    title: '<?php echo app('translator')->get("Verifique os dados inseridos e submeta outra vez"); ?>.'
                  })
                },
            },
            error: (response) => {
              $('form#basic-sale-config button.save').addClass('d-none');
              $('form#basic-sale-config button.saved').addClass('d-none');
              $('form#basic-sale-config button.saving').addClass('d-none');
              $('form#basic-sale-config button.error').removeClass('d-none');
              setTimeout(() => {
                $('form#basic-sale-config button.save').removeClass('d-none');
                $('form#basic-sale-config button.saved').addClass('d-none');
                $('form#basic-sale-config button.saving').addClass('d-none');
                $('form#basic-sale-config button.error').addClass('d-none');
              }, 2000)
            }
        });
    }
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/company/config/parts/mini/sale.blade.php ENDPATH**/ ?>