<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title"><?php echo app('translator')->get('Detalhes de inventário'); ?></h3>
                </div>
                <div class="card-body">
                    <form role="form" id="load-inventory">
                        <div class="row">
                            <div class="form-group col-sm-6">
                                <label for="warehouse"><?php echo app('translator')->get('Armazéns'); ?></label>
                                <select class="selectpicker form-control" data-style="btn-outline-primary"
                                    data-live-search="false" name="warehouse">
                                    <?php $__currentLoopData = $warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warehouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($warehouse->id); ?>" data-tokens="<?php echo e($warehouse->id); ?>">
                                        <?php echo e($warehouse->name); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="form-group col-sm-6">
                                <label for="category[]"><?php echo app('translator')->get('Categorias'); ?></label>
                                <select class="selectpicker form-control" multiple data-style="btn-outline-primary"
                                    data-live-search="false" name="categories[]">
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($category->id); ?>" data-tokens="<?php echo e($category->id); ?>">
                                        <?php echo e($category->name); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-6">
                                <button type="submit"
                                    class="btn btn-sm btn-outline-primary save"><?php echo app('translator')->get('Verificar'); ?></button>

                                <a href="#" class="btn btn-sm btn-outline-primary thermal"><?php echo app('translator')->get('Impressora Térmica'); ?></a>
                                <a href="#" class="btn btn-sm btn-outline-primary a4"><?php echo app('translator')->get('Impressora A4'); ?></a>

                                <button type="button"
                                    class="btn btn-sm btn-outline-success d-none saved"><?php echo app('translator')->get('Verificado'); ?></button>
                                <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                                        class="fa fa-spinner fa-spin fa-circle-notch"
                                        aria-hidden="true"></i><?php echo app('translator')->get('Verificando'); ?></button>
                                <button type="button"
                                    class="btn btn-sm btn-outline-danger d-none error"><?php echo app('translator')->get('Erro'); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>



<?php $__env->startPush('js'); ?>
<script type="text/javascript">

   $('a.thermal').on('click', function (event) {
        event.preventDefault()
        event.stopPropagation()
        let data = $('form#load-inventory').serialize();
        let url = '<?php echo e(URL::signedRoute('web.stock.inventory.thermal')); ?>&'+data
        goto(url)
   });
   $('a.a4').on('click', function (event) {
        event.preventDefault()
        event.stopPropagation()
        let data = $('form#load-inventory').serialize();
        let url = '<?php echo e(URL::signedRoute('web.stock.inventory.a4')); ?>&'+data
        goto(url)
   });


    $(document).ready(function () {
        $.validator.setDefaults({
            submitHandler: loadInventory
        });

        $('#load-inventory').validate({
            rules: {

            },
            messages: {
                quantity: {
                    required: 'Este campo é obrigatório',
                    min: 'Deve ser no mínimo zero'
                },
                discount: {
                    min: 'Deve ser no mínimo zero'
                },
            },
            errorElement: 'span',
            errorPlacement: function (error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight: function (element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });
    });


function loadInventory() {
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
    });

    let data = $('form#load-inventory').serializeArray();

    $.ajax({
        ...ajaxSettings,
        method: 'POST',
        url: "<?php echo e(URL::signedRoute('api.stock.inventory')); ?>",
        data: data,
        beforeSend: function () {
            $('form#load-inventory button.save').addClass('d-none');
            $('form#load-inventory button.saved').addClass('d-none');
            $('form#load-inventory button.error').addClass('d-none');
            $('form#load-inventory button.saving').removeClass('d-none');
        },
        statusCode: {
            200: function (response) {
                Toast.fire({
                    type: 'success',
                    title: '<?php echo app('translator')->get("Item added"); ?>.'
                })

                $('form#load-inventory button.save').removeClass('d-none');
                $('form#load-inventory button.saved').addClass('d-none');
                $('form#load-inventory button.saving').addClass('d-none');
                $('form#load-inventory button.error').addClass('d-none');

                handlebar.init(response.data);
            },
            401: (response) => {

                Toast.fire({
                    type: 'error',
                    title: '<?php echo app('translator')->get("Volte a fazer o login"); ?>.'
                })

                $.ajax({
                    url: "<?php echo e(URL::signedRoute('web.system.exit')); ?>",
                    dataType: "HTML",
                    success: function (response) {
                        setTimeout(() => {
                            reload();
                        }, 1500);
                    }
                });
            },
            403: () => {
                reload();
            },
            422: (response) => {
                Toast.fire({
                    type: 'error',
                    title: '<?php echo app('translator')->get("Verifique os dados inseridos e submeta outra vez"); ?>.'
                })

                $('form#load-inventory button.save').removeClass('d-none');
                $('form#load-inventory button.saved').addClass('d-none');
                $('form#load-inventory button.saving').addClass('d-none');
                $('form#load-inventory button.error').addClass('d-none');
            },
        },
        error: (response) => {
            $('form#load-inventory button.save').addClass('d-none');
            $('form#load-inventory button.saved').addClass('d-none');
            $('form#load-inventory button.saving').addClass('d-none');
            $('form#load-inventory button.error').removeClass('d-none');
            setTimeout(() => {
                $('form#load-inventory button.save').removeClass('d-none');
                $('form#load-inventory button.saved').addClass('d-none');
                $('form#load-inventory button.saving').addClass('d-none');
                $('form#load-inventory button.error').addClass('d-none');
            }, 2000)
        }
    });
}
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/stock/stockmove/inventory/parts/form.blade.php ENDPATH**/ ?>