<form role="form" id="edit-provider">
  <div class="row">
    <div class="form-group col-sm-6">
      <label for="name"><?php echo app('translator')->get('Nome'); ?></label>
      <input type="text" name="name" class="form-control" id="name" value="<?php echo e($provider->name); ?>"
        placeholder="Total Fuels">
    </div>

    <div class="form-group col-sm-6">
      <label for="contact"><?php echo app('translator')->get('Contacto'); ?></label>
      <input type="text" name="contact" class="form-control" id="contact" value="<?php echo e($provider->contact); ?>"
        placeholder="8569874565">
    </div>

    <div class="form-group col-sm-4">
      <label for="responsible"><?php echo app('translator')->get('Responsável'); ?></label>
      <input type="text" name="responsible" class="form-control" id="responsible" value="<?php echo e($provider->responsible); ?>"
        placeholder="15000">
    </div>

    <div class="form-group col-sm-4">
      <label for="address"><?php echo app('translator')->get('Endereço'); ?></label>
      <input type="text" name="address" class="form-control" id="address" value="<?php echo e($provider->address); ?>"
        placeholder="Av.24 de Julho">
    </div>

    <div class="form-group col-sm-4">
      <label for="gender"><?php echo app('translator')->get('Associar cliente'); ?></label>
      <select class="selectpicker form-control" data-style="btn-outline-primary" data-size="4" data-live-search="true"
        name="customer">
        <option value="" data-tokens=""></option>
        <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <option value="<?php echo e($customer->id); ?>" data-tokens="<?php echo e($customer->code); ?>" <?php echo e($provider->is($customer->provider) ? 'selected' : ''); ?>>
          <?php echo e($customer->name); ?> </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </select>
    </div>
  </div>

  <div class="row">
    <div class="col-12">
      <button type="submit" class="btn btn-sm btn-outline-primary save"><?php echo app('translator')->get('Salvar'); ?></button>
      <button type="button" class="btn btn-sm btn-outline-success d-none saved"><?php echo app('translator')->get('Salvo'); ?></button>
      <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
          class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i><?php echo app('translator')->get('Salvando'); ?></button>
      <button type="button" class="btn btn-sm btn-outline-danger d-none error"><?php echo app('translator')->get('Erro'); ?></button>
    </div>
  </div>
</form>


<?php $__env->startSection('plugins.JqueryValidation', true); ?>
<?php $__env->startSection('plugins.Sweetalert2', true); ?>
<?php $__env->startSection('plugins.SelectPicker', true); ?>

<?php $__env->startPush('js'); ?>
<script type="text/javascript">
  $(document).ready(function () {
      $.validator.setDefaults({
        submitHandler: saveProvider
      });

      $('#edit-provider').validate({
        rules: {
            name:{
                required:true,
                minlength:2
            },
            contact:{
                required:true,
            },
        },
        messages: {
            name:{
                required:'Por favor introduza o nome do item',
                minlength:'O nome deve ter no mínimo 2 caracteres'
            },
            contact:{
                required:'Introduza o codigo do produto',
            },
        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
          error.addClass('invalid-feedback');
          element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
          $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
          $(element).removeClass('is-invalid');
        }
      });
    });




    function saveProvider(){
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
      });



        let data = $('form#edit-provider').serializeArray();

        $.ajax({
            ...ajaxSettings,
            method:'PUT',
            url: "<?php echo e(URL::signedRoute('api.stock.providers.update', ['provider' => $provider->id])); ?>",
            data: data,
            beforeSend: function(){
              $('form#edit-provider button.save').addClass('d-none');
              $('form#edit-provider button.saved').addClass('d-none');
              $('form#edit-provider button.error').addClass('d-none');
              $('form#edit-provider button.saving').removeClass('d-none');
            },
            statusCode : {
                202: function(response){
                  Toast.fire({
                    type: 'success',
                    title: '<?php echo app('translator')->get("Provider has been updates"); ?>.'
                  })

                  $('form#edit-provider button.save').addClass('d-none');
                  $('form#edit-provider button.saved').removeClass('d-none');
                  $('form#edit-provider button.saving').addClass('d-none');
                  $('form#edit-provider button.error').addClass('d-none');
                    setTimeout(() => {
                        goto(response.url.web);
                    }, 3000)
                },
                401:(response) =>{

                    Toast.fire({
                        type: 'error',
                        title: '<?php echo app('translator')->get("Volte a fazer o login"); ?>.'
                    })

                    $.ajax({
                        url: "<?php echo e(URL::signedRoute('web.system.exit')); ?>",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
                422:(response) =>{
                  Toast.fire({
                    type: 'error',
                    title: '<?php echo app('translator')->get("Verifique os dados inseridos e submeta outra vez"); ?>.'
                  })
                },
            },
            error: (response) => {
              $('form#edit-provider button.save').addClass('d-none');
              $('form#edit-provider button.saved').addClass('d-none');
              $('form#edit-provider button.saving').addClass('d-none');
              $('form#edit-provider button.error').removeClass('d-none');
              setTimeout(() => {
                $('form#edit-provider button.save').removeClass('d-none');
                $('form#edit-provider button.saved').addClass('d-none');
                $('form#edit-provider button.saving').addClass('d-none');
                $('form#edit-provider button.error').addClass('d-none');
              }, 2000)
            }
        });
    }
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/stock/provider/show/parts/mini/edit.blade.php ENDPATH**/ ?>