<?php $__env->startSection('plugins.Datatables', true); ?>
<?php $__env->startPush('js'); ?>
<script type="text/javascript">
    $(document).ready(function () {
        initDatatable();
    });
</script>
<?php $__env->stopPush(); ?>


<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <a href="<?php echo e(URL::signedRoute('web.customer.create')); ?>" class="btn btn-sm btn-outline-primary"><?php echo app('translator')->get('Criar
                novo'); ?></a>
        </h3>
    </div>
    <!-- /.card-header -->
    <div class="card-body">
        <table id="table" class="sb-datatable table table-bordered table-striped display compact">
            <thead>
                <tr>
                    <th><?php echo app('translator')->get('Nome'); ?></th>
                    <th><?php echo app('translator')->get('Codigo'); ?></th>
                    <th><?php echo app('translator')->get('Telefone'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr ondblclick="goto('<?php echo e(URL::signedRoute('web.customer.show', ['customer'=>$customer->id])); ?>')"
                    class="cursor-pointer">
                    <td><?php echo e($customer->name); ?></td>
                    <td><?php echo e($customer->code); ?></td>
                    <td><?php echo e($customer->phone); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </tbody>
            <tfoot>
                <tr>
                    <th><?php echo app('translator')->get('Nome'); ?></th>
                    <th><?php echo app('translator')->get('Codigo'); ?></th>
                    <th><?php echo app('translator')->get('Telefone'); ?></th>
                </tr>
            </tfoot>
        </table>
    </div>
    <!-- /.card-body -->
</div><?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/customers/customer/list/parts/table.blade.php ENDPATH**/ ?>