<dl class="row">

    <div class="col-sm-6 col-md-4">
        <dt><?php echo app('translator')->get('Documento'); ?></dt>
        <dd><?php echo e($proforma->name()); ?></dd>
    </div>
    <div class="col-sm-6 col-md-4">
        <dt><?php echo app('translator')->get('Data de emissão'); ?></dt>
        <dd><?php echo e($proforma->issueDate()); ?></dd>
    </div>

    <div class="col-sm-6 col-md-4">
        <dt><?php echo app('translator')->get('Operador'); ?></dt>
        <dd><?php echo e($proforma->operator()); ?></dd>
    </div>
    <div class="col-sm-6 col-md-4">
        <dt><?php echo app('translator')->get('Valor total'); ?></dt>
        <dd><?php echo e(number_format($proforma->totalAmount(), 2)); ?></dd>
    </div>
</dl>

<dl class="row">
    <div class="col-sm-6 col-md-4">

        <dt><?php echo app('translator')->get('Cliente'); ?></dt>
        <?php if($proforma->customer): ?>
        <dd><a
                href="<?php echo e(URL::route('web.customer.show', ['customer'=>  $proforma->customer->id])); ?>"><?php echo e($proforma->customer_name); ?></a>
        </dd>
        <?php else: ?>
        <dd><?php echo e($proforma->customer_name); ?></dd>
        <?php endif; ?>
    </div>

    <div class="col-sm-6 col-md-4">
        <dt><?php echo app('translator')->get('NUIT'); ?></dt>
        <dd><?php echo e($proforma->customer_nuit); ?></dd>
    </div>
</dl>

<?php echo $__env->make('sales.proforma.show.parts.mini.btn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<div class="row">
    <div class="col-12 table-responsive">
        <table class="table table-sm table-body table-bordered my-1 mt-3">
            <thead class="">
                <tr>
                    <th class="text-left;"><?php echo app('translator')->get('Codigo'); ?></th>
                    <th class="text-left;"><?php echo app('translator')->get('Artigo'); ?></th>
                    <th class="text-left;"><?php echo app('translator')->get('Quantidade'); ?></th>
                    <th class="text-center"><?php echo app('translator')->get('Preço'); ?></th>
                    <th class="text-center"><?php echo app('translator')->get('Desconto'); ?></th>
                    <th class="text-center"><?php echo app('translator')->get('IVA'); ?> %</th>
                    <th class="text-center"><?php echo app('translator')->get('Subtotal'); ?></th>
                </tr>
            </thead>
            <tbody>

                <?php $__currentLoopData = $proforma->saleItens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="text-left"><?php echo e($item->sale_code); ?></td>
                    <td class="text-left"><?php echo e($item->sale_name); ?></td>
                    <td class="text-right"><?php echo e(number_format($item->quantity,  2)); ?></td>
                    <td class="text-right"><?php echo e(number_format($item->unit_amount,  2)); ?></td>
                    <td class="text-right"><?php echo e(number_format($item->discount, 2)); ?></td>
                    <td class="text-right"><?php echo e(number_format($item->vat_tax, 2)); ?></td>
                    <td class="text-right"><?php echo e(number_format($item->totalAmount(), 2)); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<?php if($proforma->obs !=null): ?>

<div class="row">
    <div class="col-12 table-responsive">
        <p class="text-justify text-xs"><span class="text-bold">OBS: </span> <?php echo e($proforma->obs); ?></p>
    </div>
</div>
<?php endif; ?>


<div class="row">
    <div class="col-12">
        <div class="w-50 float-left mt-2">
            <table class="table table-bordered table-sm">
                <thead>
                    <tr>
                        <td colspan="4"><b><?php echo app('translator')->get('Resumo de IVA'); ?></b>
                        </td>
                    </tr>
                    <tr>
                        <td class="text-right"><b><?php echo app('translator')->get('Taxa'); ?></b></td>
                        <td class="text-right"><b><?php echo app('translator')->get('Incidência'); ?></b></td>
                        <td class="text-right"><b><?php echo app('translator')->get('Total IVA'); ?></b></td>
                        <td class="text-right"><b><?php echo app('translator')->get('Motivo de isenção'); ?></b></td>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $proforma->vatResume(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="text-right"><?php echo e($item->vat_tax); ?></td>
                        <td class="text-right"><?php echo e(number_format($item->incidence, 2)); ?></td>
                        <td class="text-right"><?php echo e(number_format($item->total, 2)); ?></td>
                        <td></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <div class="w-40 float-right mt-2">
            <table class="table table-sm">
                <tbody>
                    <tr class="">
                        <td><?php echo app('translator')->get('Mercadoria ou serviços'); ?></td>
                        <td class="text-right"><?php echo e(number_format($proforma->groceriesAndServices(),2)); ?></td>
                    </tr>
                    <tr class="">
                        <td><?php echo app('translator')->get('Descontos comerciais'); ?></td>
                        <td class="text-right"><?php echo e(number_format($proforma->commercialDiscount(), 2)); ?></td>
                    </tr>

                    <tr class="">
                        <td><?php echo app('translator')->get('Desconto financeiro'); ?></td>
                        <td class="text-right"><?php echo e(number_format($proforma->financial_discount)); ?></td>
                    </tr>
                    <tr class="">
                        <td><?php echo app('translator')->get('IVA'); ?></td>
                        <td class="text-right"><?php echo e(number_format($proforma->vatResume()->sum('total'), 2)); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo app('translator')->get('Total MZN'); ?></td>
                        <td class="text-right"><?php echo e(number_format($proforma->totalAmount(), 2)); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>

    </div>

</div>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/sales/proforma/show/parts/mini/details.blade.php ENDPATH**/ ?>