<form role="form" class="d-inline" id="delete-brunch">
    <button type="submit" class="btn btn-sm btn-outline-danger save"><i class="fa fa-trash" aria-hidden="true"></i> <?php echo app('translator')->get('Apagar'); ?></button>
    <button type="button" class="btn btn-sm btn-outline-success d-none saved"><?php echo app('translator')->get('Apagado'); ?></button>
    <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
            class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i><?php echo app('translator')->get('Apagando'); ?></button>
    <button type="button" class="btn btn-sm btn-outline-danger d-none error"><?php echo app('translator')->get('Erro'); ?></button>
</form>


<?php $__env->startSection('plugins.JqueryValidation', true); ?>
<?php $__env->startSection('plugins.Sweetalert2', true); ?>
<?php $__env->startPush('js'); ?>
<script type="text/javascript">
    $(document).ready(function () {
    $.validator.setDefaults({
        submitHandler: closeShift
    });

    $('#delete-brunch').validate({
        rules: {

        },
        messages: {

        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
            $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
            $(element).removeClass('is-invalid');
        }
    });
});




function closeShift() {
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
    });



    let data = $('form#delete-brunch').serializeArray();

    $.ajax({
        ...ajaxSettings,
        method: 'DELETE',
        url: "<?php echo e(URL::signedRoute('api.company.brunch.destroy', ['brunch' => $brunch->id])); ?>",
        data: data,
        beforeSend: function () {
            $('form#delete-brunch button.save').addClass('d-none');
            $('form#delete-brunch button.saved').addClass('d-none');
            $('form#delete-brunch button.error').addClass('d-none');
            $('form#delete-brunch button.saving').removeClass('d-none');
        },
        statusCode: {
            204: function (response) {
                Toast.fire({
                    type: 'success',
                    title: '<?php echo app('translator')->get("Shift has been closed"); ?>.'
                })

                $('form#delete-brunch button.save').addClass('d-none');
                $('form#delete-brunch button.saved').removeClass('d-none');
                $('form#delete-brunch button.saving').addClass('d-none');
                $('form#delete-brunch button.error').addClass('d-none');

                goto('<?php echo e(URL::signedRoute('web.company.brunch.index')); ?>');

            },
            401: (response) => {

                Toast.fire({
                    type: 'error',
                    title: '<?php echo app('translator')->get("Volte a fazer o login"); ?>.'
                })

                $.ajax({
                    url: "<?php echo e(URL::signedRoute('web.system.exit')); ?>",
                    dataType: "HTML",
                    success: function (response) {
                        setTimeout(() => {
                            reload();
                        }, 1500);
                    }
                });
            },
            422: (response) => {
                Toast.fire({
                    type: 'error',
                    title: '<?php echo app('translator')->get("Verifique os dados inseridos e submeta outra vez"); ?>.'
                })
            },
        },
        error: (response) => {
            $('form#delete-brunch button.save').addClass('d-none');
            $('form#delete-brunch button.saved').addClass('d-none');
            $('form#delete-brunch button.saving').addClass('d-none');
            $('form#delete-brunch button.error').removeClass('d-none');
            setTimeout(() => {
                $('form#delete-brunch button.save').removeClass('d-none');
                $('form#delete-brunch button.saved').addClass('d-none');
                $('form#delete-brunch button.saving').addClass('d-none');
                $('form#delete-brunch button.error').addClass('d-none');
            }, 2000)
        }
    });
}
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/company/brunch/show/parts/mini/delete.blade.php ENDPATH**/ ?>