<div class="row">
  <div class="col-12">
    <form role="form" id="edit-user-data">
      <div class="card-body">

        <div class="row">
          <div class="form-group col-sm-8">
            <label for="name"><?php echo app('translator')->get('Nome'); ?></label>
            <input type="text" name="name" class="form-control" id="name" value="<?php echo e($user->name); ?>" placeholder="Tavares Alvaro">
          </div>

          <div class="form-group col-sm-4">
            <label for="email"><?php echo app('translator')->get('Email'); ?></label>
            <input type="email" name="email" class="form-control" id="email" value="<?php echo e($user->email); ?>" placeholder="exemplo@mail.com">
          </div>
        </div>

      </div>
      <!-- /.card-body -->
      <div class="card-footer">
        <button type="submit" class="btn btn-sm btn-outline-primary save"><?php echo app('translator')->get('Salvar'); ?></button>
        <button type="button" class="btn btn-sm btn-outline-success d-none saved"><?php echo app('translator')->get('Salvo'); ?></button>
        <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
            class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i><?php echo app('translator')->get('Salvando'); ?></button>
        <button type="button" class="btn btn-sm btn-outline-danger d-none error"><?php echo app('translator')->get('Erro'); ?></button>
      </div>
    </form>
  </div>
</div>

<?php $__env->startPush('js'); ?>
<script type="text/javascript">
  $(document).ready(function () {
        $.validator.setDefaults({
          submitHandler: saveUserData
        });


        $('#edit-user-data').validate({
          rules: {

          },
          messages: {

          },
          errorElement: 'span',
          errorPlacement: function (error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
          },
          highlight: function (element, errorClass, validClass) {
            $(element).addClass('is-invalid');
          },
          unhighlight: function (element, errorClass, validClass) {
            $(element).removeClass('is-invalid');
          }
        });
    });
    function saveUserData(){
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
      });


        let data = $('form#edit-user-data').serializeArray();

        $.ajax({
            ...ajaxSettings,
            method:'PUT',
            url: "<?php echo e(URL::signedRoute('api.company.brunch.users.update', ['user' => $user->id, 'brunch' => $brunch->id])); ?>",
            data: data,
            beforeSend: function(){
              $('form#edit-user-data button.save').addClass('d-none');
              $('form#edit-user-data button.saved').addClass('d-none');
              $('form#edit-user-data button.error').addClass('d-none');
              $('form#edit-user-data button.saving').removeClass('d-none');
            },
            statusCode : {
                202: function(response){
                  Toast.fire({
                    type: 'success',
                    title: '<?php echo app('translator')->get("Funções do usuário foram atualizadas"); ?>.'
                  })

                  $('form#edit-user-data button.save').addClass('d-none');
                  $('form#edit-user-data button.saved').removeClass('d-none');
                  $('form#edit-user-data button.saving').addClass('d-none');
                  $('form#edit-user-data button.error').addClass('d-none');
                    setTimeout(() => {
                        goto(response.url.web);
                    }, 3000)
                },
                401:(response) =>{

                    Toast.fire({
                        type: 'error',
                        title: '<?php echo app('translator')->get("Volte a fazer o login"); ?>.'
                    })

                    $.ajax({
                        url: "<?php echo e(URL::signedRoute('web.system.exit')); ?>",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
                422:(response) =>{
                  Toast.fire({
                    type: 'error',
                    title: '<?php echo app('translator')->get("Verifique os dados inseridos e submeta outra vez"); ?>.'
                  })
                },
            },
            error: (response) => {
              $('form#edit-user-data button.save').addClass('d-none');
              $('form#edit-user-data button.saved').addClass('d-none');
              $('form#edit-user-data button.saving').addClass('d-none');
              $('form#edit-user-data button.error').removeClass('d-none');
              setTimeout(() => {
                $('form#edit-user-data button.save').removeClass('d-none');
                $('form#edit-user-data button.saved').addClass('d-none');
                $('form#edit-user-data button.saving').addClass('d-none');
                $('form#edit-user-data button.error').addClass('d-none');
              }, 2000)
            }
        });
    }
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/users/show/parts/mini/data.blade.php ENDPATH**/ ?>