<!DOCTYPE html>
<html>
<head>
    <title><?php echo e($customer->name); ?></title>
</head>
<style type="text/css">
    body{
        font-family: 'Roboto Condensed', sans-serif;
    }
    .m-0{
        margin: 0px;
    }

    .p-0{
        padding: 0px;
    }
    .pt-5{
        padding-top:5px;
    }
    .mt-10{
        margin-top:10px;
    }
    .text-center{
        text-align:center !important;
    }
    .w-100{
        width: 100%;
    }
    .w-50{
        width:50%;
    }
    .w-85{
        width:85%;
    }
    .w-15{
        width:15%;
    }
    .logo img{
        width:45px;
        height:45px;
        padding-top:30px;
    }
    .logo span{
        margin-left:8px;
        top:19px;
        position: absolute;
        font-weight: bold;
        font-size:25px;
    }
    .gray-color{
        color:#5D5D5D;
    }
    .text-bold{
        font-weight: bold;
    }
    .border{
        border:1px solid black;
    }
    table tr,th,td{
        border: 1px solid #d2d2d2;
        border-collapse:collapse;
        padding:7px 8px;
    }
    table tr th{
        background: #F4F4F4;
        font-size:15px;
    }
    table tr td{
        font-size:13px;
    }
    table{
        border-collapse:collapse;
    }
    .box-text p{
        line-height:10px;
    }
    .float-left{
        float:left;
    }
    .float-right{
        float:right;
    }
    .total-part{
        font-size:16px;
        line-height:12px;
    }
    .total-right p{
        padding-right:20px;
    }
    .seller {
            float: right;
            font-size: 16px;
            margin-bottom: 30px;
    }
     .mt-50{
        margin-top: 50px;
        margin-bottom: 0px;
    }
</style>
<body>
<div class="head-title">

    <div class="text-center m-0 p-0" style="font-size: 14px">
        <img src="<?php echo e($company->logoPhoto()); ?>" width="110" style="object-fit: scale-down;" />
        <p class="m-0 pt-5 text-bold w-100"><span class="gray-color"><?php echo e($company->name); ?> </span></p>
    </div>

    <h4 class="text-center m-0 p-0"> <?php echo app('translator')->get('Extrato'); ?> -

    <?php if($type=='geral'): ?>
        <?php echo app('translator')->get('Geral'); ?>
    <?php endif; ?>
    <?php if($type=='invoice'): ?>
        <?php echo app('translator')->get('Fatura'); ?>
    <?php endif; ?>
    <?php if($type=='cashSale'): ?>
        <?php echo app('translator')->get('Venda Dinheiro'); ?>
    <?php endif; ?>

    <?php if($type=='deliveryNote'): ?>
        <?php echo app('translator')->get('Guia de Remessa'); ?>
    <?php endif; ?>
    <br><?php echo e($from); ?> - <?php echo e($to); ?>

    </h4>

</div>
<div class="add-detail mt-10">
    <div class="w-50 float-left mt-10" style="font-size: 14px">
        
    </div>
    <div class="inv">
          <div class="users">
            
          </div>
    </div>
    <div style="clear: both;"></div>
</div>
<div class="table-section bill-tbl w-100 mt-10">
    <table class="table w-100 mt-10">
        <tr>
            <th class="w-50"><?php echo app('translator')->get('De'); ?></th>
            <th class="w-50"><?php echo app('translator')->get('Para'); ?> (<?php echo app('translator')->get('Cliente'); ?>)</th>
        </tr>
        <tr>
            <td>
                <div class="box-text">
                    <p class="m-0 pt-5 text-bold w-100"><span class="gray-color"><?php echo e($company->name); ?> </span></p>
                    <p class="m-0 pt-5 text-bold w-100"><?php echo app('translator')->get('NUIT'); ?>: <span class="gray-color"><?php echo e($company->nuit); ?></span></p>
                    <p class="m-0 pt-5 text-bold w-100"><?php echo app('translator')->get('Endereço'); ?>: <span class="gray-color"><?php echo e($company->address); ?></span></p>
                    <p class="m-0 pt-5 text-bold w-100"><?php echo app('translator')->get('Email'); ?>: <span class="gray-color"><?php echo e($company->email); ?></span></p>
                    <p class="m-0 pt-5 text-bold w-100"><?php echo app('translator')->get('Telefone'); ?>: <span class="gray-color"><?php echo e($company->phone); ?></span></p>
                </div>
            </td>
            <td>
                <div class="box-text" >
                    <div><span class="m-0 pt-5 text-bold w-100"><?php echo app('translator')->get('Nome'); ?>: </span><?php echo e($customer->name); ?></div>
                    <div><span class="m-0 pt-5 text-bold w-100"><?php echo app('translator')->get('Endereço'); ?>: </span><?php echo e($customer->adress); ?></div>
                    <div><span class="m-0 pt-5 text-bold w-100"><?php echo app('translator')->get('Telefone'); ?>: </span><?php echo e($customer->phone); ?></div>
                </div>
            </td>
        </tr>
    </table>
</div>


     <main>
      <table class='mt-10 w-100'>
        <thead>
          <tr>
            <th><?php echo app('translator')->get('Ordem'); ?></th>
            <th><?php echo app('translator')->get('Data de emissao'); ?></th>
            <th><?php echo app('translator')->get('Documento'); ?></th>
            <th><?php echo app('translator')->get('Valor Total'); ?></th>
            <th><?php echo app('translator')->get('Valor pago'); ?></th>
            <th><?php echo app('translator')->get('Valor Pendente'); ?></th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $operations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

            <?php if($item->name!=''): ?>


                    <tr style="text-align: center">
                        <td class="desc"><?php echo e($item->id); ?></td>
                        <td class="total"><?php echo e($item->date); ?></td>
                        <td class="total"><?php echo e($item->name); ?></td>
                        <td class="total"><?php echo e(number_format($item->totalamount)); ?></td>


                        <td class="total">
                        <?php if($item->paidamount==0): ?>
                                <?php echo e(number_format($item->credit)); ?>

                                <?php else: ?>
                                <?php echo e($item->paidamount); ?>

                        <?php endif; ?>
                        </td>

                        <td class="total"><?php echo e(number_format($item->pendingamount)); ?></td>

                    </tr>

            <?php endif; ?>

          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          <tr style="background-color:#f5f5f5">
            <td colspan="5" class="grand total"><strong><?php echo app('translator')->get('Total'); ?></strong></td>
            <td class="grand total" style="text-align: center"><strong><?php echo e(number_format($total,2)); ?></strong></td>
          </tr>
          <tr style="background-color:#dcfce4">
            <td colspan="5" class="grand total" ><strong><?php echo app('translator')->get('Total Pago'); ?></strong></td>
            <td class="grand total" style="text-align: center"><strong><?php echo e(number_format($paidamount,2)); ?></strong></td>
          </tr>
          <tr style="background-color:#fce5e1">
            <td colspan="5" class="grand total" ><strong><?php echo app('translator')->get('Total'); ?> <?php echo app('translator')->get('Valor Pendente'); ?></strong></td>
            <td class="grand total" style="text-align: center"><strong><?php echo e(number_format($pendingamount,2)); ?></strong></td>
          </tr>
        </tbody>
      </table>



      <!--Bank details -->



         <div class="notice" style="font-size: 12px">

            <sub><?php echo e(config("app.name")); ?>, <?php echo app('translator')->get('Licenciado a'); ?> <?php echo e($company->name); ?><br><?php echo app('translator')->get('Processado por computador'); ?> </sub>


         </div>




     </main>

</html>

<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/reports/customer/index.blade.php ENDPATH**/ ?>