<?php $__env->startSection('plugins.Datatables', true); ?>
<?php $__env->startPush('js'); ?>
<script type="text/javascript">
    $(document).ready(function () {
        initDatatable();
    });
</script>
<?php $__env->stopPush(); ?>


<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <a href="<?php echo e(URL::signedRoute('web.stock.saleable.create')); ?>"
                class="btn btn-sm btn-outline-primary"><?php echo app('translator')->get('Criar
                novo'); ?></a>
        </h3>
    </div>
    <!-- /.card-header -->
    <div class="card-body">
        <table id="table" class="sb-datatable table table-bordered table-striped display compact">
            <thead>
                <tr>
                    <th><?php echo app('translator')->get('Nome'); ?></th>
                    <th><?php echo app('translator')->get('Codigo'); ?></th>
                    <th><?php echo app('translator')->get('Unidade'); ?></th>
                    <th><?php echo app('translator')->get('Preço'); ?></th>
                    <th><?php echo app('translator')->get('Regime de IVA'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $saleables; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $saleable): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr ondblclick="goto('<?php echo e(URL::signedRoute('web.stock.saleable.show', ['saleable'=>$saleable->id])); ?>')"
                    class="cursor-pointer">
                    <td><?php echo e($saleable->name); ?></td>
                    <td><?php echo e($saleable->code); ?></td>
                    <td><?php echo e($saleable->saleUnit->name); ?></td>
                    <td><?php echo e(number_format($saleable->price, 2)); ?></td>
                    <td><?php echo e($saleable->vatScheme->name); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </tbody>
            <tfoot>
                <tr>
                    <th><?php echo app('translator')->get('Nome'); ?></th>
                    <th><?php echo app('translator')->get('Codigo'); ?></th>
                    <th><?php echo app('translator')->get('Unidade'); ?></th>
                    <th><?php echo app('translator')->get('Preço'); ?></th>
                    <th><?php echo app('translator')->get('Regime de IVA'); ?></th>
                </tr>
            </tfoot>
        </table>
    </div>
    <!-- /.card-body -->
</div><?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/stock/saleable/list/parts/table.blade.php ENDPATH**/ ?>