<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <?php echo $__env->make('stock.transfers.parts.mini.finalize-btn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php echo $__env->make('stock.transfers.parts.mini.cancel-btn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </h3>
    </div>
    <!-- /.card-header -->
    <div class="card-body">
        <div id="table"></div>
    </div>
</div>

<?php $__env->startSection('plugins.Handlebars', true); ?>
<script id="table-template" type="text/x-handlebars-template">
    <table class="table table-sm table-bordered table-hover">
            <thead>
                <tr>
                    <th><?php echo app('translator')->get('Produto'); ?></th>
                    <th><?php echo app('translator')->get('Quantidade'); ?></th>
                    <th><?php echo app('translator')->get('Origem'); ?></th>
                    <th><?php echo app('translator')->get('Destino'); ?></th>
                    <th><?php echo app('translator')->get('Responsável'); ?></th>
                    <th><?php echo app('translator')->get('Cancelar'); ?></th>
                </tr>
            </thead>
            <tbody>
            {{#each items }}
                <tr>
                    <td>{{ this.saleable }}</td>

                    <td>{{ this.from.quantity }}</td>
                    <td>{{ this.from.warehouse }}</td>
                    <td>{{ this.to.warehouse }}</td>
                    <td>{{ this.user }}</td>
                    <td><button type="button" class="btn btn-outline-danger btn-sm delete" onclick="remove('{{ links.self }}')">
                        <span class="badge" ><i class="fa fa-trash"></i></span>
                    </button></td>
                </tr>
            {{/each}}

            </tbody>
        </table>
</script>
<?php $__env->startPush('js'); ?>

<script type="text/javascript">
    $(document).ready(loadItems);

    function loadItems(){
        $.ajax({
            ...ajaxSettings,
            type: "GET",
            url: "<?php echo e(URL::signedRoute('api.stock.groups.show', ['group' => $group->id])); ?>",
            dataType: "JSON",
            statusCode: {
                401: (response) => {
                    $.ajax({
                        url: "<?php echo e(URL::signedRoute('web.system.exit')); ?>",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
            },
            success: function (response) {
                handlebar.init(response.data.transfers);
            }
        });
    }
    function remove(url){
        $.ajax({
            ...ajaxSettings,
            type: "DELETE",
            url:url,
            dataType: "JSON",
            statusCode: {
                204: loadItems,
                401: (response) => {

                    Toast.fire({
                        type: 'error',
                        title: '<?php echo app('translator')->get("Volte a fazer o login"); ?>.'
                    })

                    $.ajax({
                        url: "<?php echo e(URL::signedRoute('web.system.exit')); ?>",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
                403: () => {
                    reload();
                },
            },
        });
    }

    let handlebar = {
        init: function (list) {
            this.cacheDOM();
            this.render(list);
        },
        cacheDOM: function () {
            this.$tableContainer = $('#table');
        },
        render: function (list) {
            if (list.length) {
                var template = Handlebars.compile($("#table-template").html());
                var context = {
                    'items': list
                };
                var html = template(context);
                this.$tableContainer.html(html);
                this.$tableContainer.parents('.card').show();
            } else {
                this.$tableContainer.parents('.card').hide();
            }
        },
    };

</script>
<?php $__env->stopPush(); ?><?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/stock/transfers/parts/handlebar-list.blade.php ENDPATH**/ ?>