<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <script type="text/javascript">
        window.print();
            window.onafterprint = back;

            function back() {
                window.history.back();
            }
    </script>
    <?php echo $__env->make('sales.delivery_note.pdf.style', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>
<?php
$company = $deliveryNote->company;
$customer = $deliveryNote->customer;
?>

<body style="font-size: 16px;">
    <div class="container-fluid">
        <div class="float-left w-60 text-left">

            <img src="<?php echo e($company->logoPhoto()); ?>" width="150" style="object-fit: scale-down;" />

            <br><b><?php echo e($company->name); ?></b><br>
            <b><?php echo e($company->nuit); ?></b> <br>
            <?php echo e($company->address); ?><br>
            <?php echo e($company->email); ?><br>
            <?php echo e($company->phone); ?>

            <br>
        </div>

        <div class="float-right w-40 text-right">
            <table class="table table-sm">
                <tbody>
                    <tr>
                        <td class="border-0 text-left"><b><?php echo app('translator')->get('Cliente'); ?> : </b></td>
                        <td class="border-0 text-right"><?php echo e($customer->code); ?></td>
                    </tr>
                    <tr class="border-0 ">
                        <td class="border-0 text-left"><?php echo app('translator')->get('Nome'); ?> </td>
                        <td class="border-0 text-right"><?php echo e($customer->name); ?></td>
                    </tr>
                    <tr class="border-0 ">
                        <td class="border-0 text-left"><?php echo app('translator')->get('NUIT'); ?></td>
                        <td class="border-0 text-right"><?php echo e($customer->nuit); ?></td>
                    </tr>
                    <tr class="border-0 ">
                        <td class="border-0 text-left"><?php echo app('translator')->get('Telefone'); ?></td>
                        <td class="border-0 text-right"><?php echo e($customer->phone); ?></td>
                    </tr>

                    <tr>
                        <td class="border-0 text-right" colspan="2"><?php echo e($customer->address); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>


    <div class="container-fluid">
        <div class="w-50 float-left mt-3">
            <table class="table table-sm">
                <tbody>

                    <tr class="">
                        <td><?php echo app('translator')->get('Documento'); ?></td>
                        <td class="text-right">
                            <b><?php echo app('translator')->get('Guia de remessa'); ?></b>
                        </td>
                    </tr>

                    <tr class="">
                        <td><?php echo app('translator')->get('Moeda'); ?></td>
                        <td class="text-right">MZN</td>
                    </tr>
                    <tr>
                        <td><?php echo app('translator')->get('Data de emissao'); ?></td>
                        <td class="text-right"><?php echo e($deliveryNote->validated_at->format('d/m/Y')); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo app('translator')->get('Data de validade'); ?></td>
                        <td class="text-right">
                            <?php echo e((new \Carbon\Carbon($deliveryNote->due_date))->format('d/m/Y')); ?></td>
                    </tr>
                    <tr class="">
                        <td><?php echo app('translator')->get('Operador'); ?></td>
                        <td class="text-right"><?php echo e($deliveryNote->user->name); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>



        <div class="w-40 float-right mt-3">
            <table class="table text-bold table-sm text-right">
                <tbody>
                    <tr class="">
                        <td class="border-top-0"><?php echo e($deliveryNote->order()); ?></td>
                    </tr>
                    <tr>
                        <td class="border-top-0"> <?php echo e($deliveryNote->name()); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <div class="container-fluid">

        <div class="table-responsive">
            <table class="table table-sm table-body table-bordered mb-1">
                <thead class="">
                    <tr>
                        <th class="text-left;"><?php echo app('translator')->get('Codigo'); ?></th>
                        <th class="text-left;"><?php echo app('translator')->get('Artigo'); ?></th>
                        <th class="text-center"><?php echo app('translator')->get('Preço'); ?></th>
                        <th class="text-center"><?php echo app('translator')->get('Qty'); ?></th>
                        <th class="text-center"><?php echo app('translator')->get('Desconto'); ?></th>
                        <th class="text-center"><?php echo app('translator')->get('IVA'); ?> %</th>
                        <th class="text-center"><?php echo app('translator')->get('Subtotal'); ?></th>
                    </tr>
                </thead>
                <tbody>

                    <?php $__currentLoopData = $deliveryNote->saleItens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="text-left"><?php echo e($item->sale_code); ?></td>
                        <td class="text-left"><?php echo e($item->sale_name); ?></td>
                        <td class="text-right"><?php echo e(number_format($item->unit_amount,  2)); ?></td>
                        <td class="text-right"><?php echo e(number_format($item->quantity)); ?></td>
                        <td class="text-right"><?php echo e(number_format($item->discount, 2)); ?></td>
                        <td class="text-right"><?php echo e(number_format($item->vat_tax, 2)); ?></td>
                        <td class="text-right"><?php echo e(number_format($item->totalAmount(), 2)); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

           <table class="mt-3" style="display: none">
                <tr>
                    <td><sub><?php echo e(config("app.name")); ?>, <?php echo app('translator')->get('Licença'); ?>
                            <span class="text-bold text-sm"><?php echo e(config("app.finance_dep_global_auth")); ?></span> /
                            <?php echo e(Auth::user()->brunch->daf_auth); ?> </sub></td>
                </tr>
            </table>
        </div>

        <?php if($deliveryNote->obs !=null): ?>

        <div class="row">
            <div class="col-12 table-responsive">
                <p class="text-justify text-xs"><span class="text-bold">OBS: </span> <?php echo e($deliveryNote->obs); ?></p>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <div class="container-fluid">
        <div class="w-50 float-left mt-2">
            <table class="table table-bordered table-sm">
                <thead>
                    <tr>
                        <td colspan="4"><b><?php echo app('translator')->get('Resumo de IVA'); ?></b>
                        </td>
                    </tr>
                    <tr>
                        <td class="text-right"><b><?php echo app('translator')->get('Taxa'); ?></b></td>
                        <td class="text-right"><b><?php echo app('translator')->get('Incidência'); ?></b></td>
                        <td class="text-right"><b><?php echo app('translator')->get('Total IVA'); ?></b></td>
                        <td class="text-right"><b><?php echo app('translator')->get('Motivo de isenção'); ?></b></td>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $deliveryNote->vatResume(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="text-right"><?php echo e($item->vat_tax); ?></td>
                        <td class="text-right"><?php echo e(number_format($item->incidence, 2)); ?></td>
                        <td class="text-right"><?php echo e(number_format($item->total, 2)); ?></td>
                        <td></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <div class="w-40 float-right">
            <table class="table table-sm">
                <tbody>
                    <tr class="">
                        <td><?php echo app('translator')->get('Mercadoria ou serviços'); ?></td>
                        <td class="text-right"><?php echo e(number_format($deliveryNote->groceriesAndServices(),2)); ?></td>
                    </tr>
                    <tr class="">
                        <td><?php echo app('translator')->get('Descontos comerciais'); ?></td>
                        <td class="text-right"><?php echo e(number_format($deliveryNote->commercialDiscount(), 2)); ?></td>
                    </tr>

                    <tr class="">
                        <td><?php echo app('translator')->get('Desconto financeiro'); ?></td>
                        <td class="text-right"><?php echo e(number_format($deliveryNote->financial_discount)); ?></td>
                    </tr>
                    <tr class="">
                        <td><?php echo app('translator')->get('IVA'); ?></td>
                        <td class="text-right"><?php echo e(number_format($deliveryNote->vatResume()->sum('total'), 2)); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo app('translator')->get('Total MZN'); ?></td>
                        <td class="text-right"><?php echo e(number_format($deliveryNote->totalAmount(), 2)); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>


    </div>


    

    <div class="footer fixed-bottom">
        <div class="row mb-5">
            
        </div>
        </table>
        <div class="container-fluid">
            <table class="" width="100%">
                <tr>
                    <td>
                        <?php echo Auth::user()->brunch->bank_data_footer; ?>

                    </td>
                </tr>
            </table>
        </div>
        <h6 style="font-size: 8px">Processado Por Computador</h6>
        <div class="conatiner" style="text-align: center">
            
            <i style="font-size: 14px"><?php echo e(config('app.name')); ?> v. 2.1 © <script>document.write(new Date().getFullYear())</script> <?php echo app('translator')->get('Licenciado a'); ?> <strong><?php echo e($company->name); ?></strong></i>
        </div>
</div>


</body>

</html>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/sales/delivery_note/print/delivery_note.blade.php ENDPATH**/ ?>