<form role="form" id="creatte-move">
    <div class="row">

        <div class="form-group col-sm-4">
            <label for="gender"><?php echo app('translator')->get('Produto'); ?></label>
            <select class="selectpicker form-control" data-style="btn-outline-primary" required data-size="4"  data-live-search="true"
                name="saleable">
                <?php $__currentLoopData = $saleables; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $saleable): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($saleable->id); ?>" data-tokens="<?php echo e($saleable->code); ?>"> <?php echo e($saleable->name); ?> </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="form-group col-sm-4">
            <label for="gender"><?php echo app('translator')->get('Armazém de destino'); ?></label>
            <select class="selectpicker form-control" data-style="btn-outline-primary" required data-size="4"
                name="warehouse">
                <?php $__currentLoopData = $warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warehouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($warehouse->id); ?>"> <?php echo e($warehouse->name); ?> </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="form-group col-sm-4">
            <label for="quantity"><?php echo app('translator')->get('Quantidade'); ?></label>
            <input type="text" name="quantity" class="form-control" id="quantity" placeholder="1">
        </div>

    </div>

    <div class="row">
        <div class="col-12">
            <button type="submit" class="btn btn-sm btn-outline-primary save"><?php echo app('translator')->get('Salvar'); ?></button>
            <button type="button" class="btn btn-sm btn-outline-success d-none saved"><?php echo app('translator')->get('Salvo'); ?></button>
            <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                    class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i><?php echo app('translator')->get('Salvando'); ?></button>
            <button type="button" class="btn btn-sm btn-outline-danger d-none error"><?php echo app('translator')->get('Erro'); ?></button>
        </div>
    </div>
</form>


<?php $__env->startSection('plugins.JqueryValidation', true); ?>
<?php $__env->startSection('plugins.Select2', true); ?>
<?php $__env->startSection('plugins.Sweetalert2', true); ?>
<?php $__env->startSection('plugins.SelectPicker', true); ?>

<?php $__env->startPush('js'); ?>
<script type="text/javascript">
$(document).ready(function () {
    $.validator.setDefaults({
        submitHandler: saveCompanyData
    });

    $('#creatte-move').validate({
        rules: {
            saleable: {
                required: true,
            },
            quantity: {
                required: true,
                min: 0
            },
            warehouse: {
                required: true,
            },
        },
        messages: {
            saleable: {
                required: 'Campo obrigatório',
            },
            quantity: {
                required: 'Campo obrigatório',
                min: 'Valor introduzido é inválido'
            },
            warehouse: {
                required: 'Campo obrigatório',
            },
        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
            $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
            $(element).removeClass('is-invalid');
        }
    });
});

$(document).ready(function () {
    $('.select2bs4').select2({
        theme: 'bootstrap4'
    })
});


function saveCompanyData() {
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
    });


    let data = $('form#creatte-move').serializeArray();

    $.ajax({
        ...ajaxSettings,
        method: 'POST',
        url: "<?php echo e(URL::signedRoute('api.stock.inventory.adjust')); ?>",
        data: data,
        beforeSend: function () {
            $('form#creatte-move button.save').addClass('d-none');
            $('form#creatte-move button.saved').addClass('d-none');
            $('form#creatte-move button.error').addClass('d-none');
            $('form#creatte-move button.saving').removeClass('d-none');
        },
        statusCode: {
            201: function (response) {
                handlebar.init(response.data);
                Toast.fire({
                    type: 'success',
                    title: '<?php echo app('translator')->get("Entrada provisoria guardada"); ?>.'
                });

                $('form#creatte-move button.save').addClass('d-none');
                $('form#creatte-move button.saved').removeClass('d-none');
                $('form#creatte-move button.saving').addClass('d-none');
                $('form#creatte-move button.error').addClass('d-none');
                setTimeout(() => {
                    $('form#creatte-move button.save').removeClass('d-none');
                    $('form#creatte-move button.saved').addClass('d-none');
                    $('form#creatte-move button.saving').addClass('d-none');
                    $('form#creatte-move button.error').addClass('d-none');
                }, 3000);
            },
            401: (response) => {

                Toast.fire({
                    type: 'error',
                    title: '<?php echo app('translator')->get("Volte a fazer o login"); ?>.'
                })

                $.ajax({
                    url: "<?php echo e(URL::signedRoute('web.system.exit')); ?>",
                    dataType: "HTML",
                    success: function (response) {
                        setTimeout(() => {
                            reload();
                        }, 1500);
                    }
                });
            },
            403: () => {
                reload();
            },
            422: (response) => {
                Toast.fire({
                    type: 'error',
                    title: '<?php echo app('translator')->get("Verifique os dados inseridos e submeta outra vez"); ?>.'
                })
            },
        },
        error: (response) => {
            $('form#creatte-move button.save').addClass('d-none');
            $('form#creatte-move button.saved').addClass('d-none');
            $('form#creatte-move button.saving').addClass('d-none');
            $('form#creatte-move button.error').removeClass('d-none');
            setTimeout(() => {
                $('form#creatte-move button.save').removeClass('d-none');
                $('form#creatte-move button.saved').addClass('d-none');
                $('form#creatte-move button.saving').addClass('d-none');
                $('form#creatte-move button.error').addClass('d-none');
            }, 2000)
        }
    });
}
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/stock/stockmove/adjust/parts/mini/form.blade.php ENDPATH**/ ?>