<form role="form" class="d-inline" id="close-shift">
    <div class="row">
        <div class="col-12">
            <button type="submit" class="btn btn-sm btn-outline-primary save"><?php echo app('translator')->get('Fechar'); ?></button>
            <button type="button" class="btn btn-sm btn-outline-success d-none saved"><?php echo app('translator')->get('Fechado'); ?></button>
            <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                    class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i><?php echo app('translator')->get('Fechando'); ?></button>
            <button type="button" class="btn btn-sm btn-outline-danger d-none error"><?php echo app('translator')->get('Erro'); ?></button>
        </div>
    </div>
</form>


<?php $__env->startSection('plugins.JqueryValidation', true); ?>
<?php $__env->startSection('plugins.Sweetalert2', true); ?>
<?php $__env->startPush('js'); ?>
<script type="text/javascript">
    $(document).ready(function () {
    $.validator.setDefaults({
        submitHandler: closeShift
    });

    $('#close-shift').validate({
        rules: {

        },
        messages: {

        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
            $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
            $(element).removeClass('is-invalid');
        }
    });
});




function closeShift() {
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
    });



    let data = $('form#close-shift').serializeArray();

    $.ajax({
        ...ajaxSettings,
        method: 'PUT',
        url: "<?php echo e(URL::signedRoute('api.shift.update', ['shift' => $shift->id])); ?>",
        data: data,
        beforeSend: function () {
            $('form#close-shift button.save').addClass('d-none');
            $('form#close-shift button.saved').addClass('d-none');
            $('form#close-shift button.error').addClass('d-none');
            $('form#close-shift button.saving').removeClass('d-none');
        },
        statusCode: {
            202: function (response) {
                Toast.fire({
                    type: 'success',
                    title: '<?php echo app('translator')->get("Shift has been closed"); ?>.'
                })

                $('form#close-shift button.save').addClass('d-none');
                $('form#close-shift button.saved').removeClass('d-none');
                $('form#close-shift button.saving').addClass('d-none');
                $('form#close-shift button.error').addClass('d-none');

                let current = <?php echo e(Route::currentRouteName() == 'web.shift.current'? 1 : 0); ?>




                if(current){
                    let url =  "<?php echo e(URL::signedRoute('web.system.exit')); ?>"
                    goto(url);
                }
                else
                    reload();

            },
            401: (response) => {

                Toast.fire({
                    type: 'error',
                    title: '<?php echo app('translator')->get("Volte a fazer o login"); ?>.'
                })

                $.ajax({
                    url: "<?php echo e(URL::signedRoute('web.system.exit')); ?>",
                    dataType: "HTML",
                    success: function (response) {
                        setTimeout(() => {
                            reload();
                        }, 1500);
                    }
                });
            },
            422: (response) => {
                Toast.fire({
                    type: 'error',
                    title: '<?php echo app('translator')->get("Verifique os dados inseridos e submeta outra vez"); ?>.'
                })
            },
        },
        error: (response) => {
            $('form#close-shift button.save').addClass('d-none');
            $('form#close-shift button.saved').addClass('d-none');
            $('form#close-shift button.saving').addClass('d-none');
            $('form#close-shift button.error').removeClass('d-none');
            setTimeout(() => {
                $('form#close-shift button.save').removeClass('d-none');
                $('form#close-shift button.saved').addClass('d-none');
                $('form#close-shift button.saving').addClass('d-none');
                $('form#close-shift button.error').addClass('d-none');
            }, 2000)
        }
    });
}
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/shifts/shift/show/parts/mini/close.blade.php ENDPATH**/ ?>