<dl class="row">

    <div class="col-sm-6 col-md-4">
        <dt><?php echo app('translator')->get('Documento'); ?></dt>
        <dd><?php echo e($recipt->name()); ?></dd>
    </div>
    <div class="col-sm-6 col-md-4">
        <dt><?php echo app('translator')->get('Data de emissão'); ?></dt>
        <dd><?php echo e($recipt->issueDate()); ?></dd>
    </div>

    <div class="col-sm-6 col-md-4">
        <dt><?php echo app('translator')->get('Operador'); ?></dt>
        <dd><?php echo e($recipt->operator()); ?></dd>
    </div>
    <div class="col-sm-6 col-md-4">
        <dt><?php echo app('translator')->get('Valor total'); ?></dt>
        <dd><?php echo e(number_format($recipt->totalAmount(), 2)); ?></dd>
    </div>
</dl>

<dl class="row">
    <div class="col-sm-6 col-md-4">
        <dt><?php echo app('translator')->get('Cliente'); ?></dt>
        <?php if($recipt->customer): ?>
        <dd><a
                href="<?php echo e(URL::route('web.customer.show', ['customer'=>  $recipt->customer->id])); ?>"><?php echo e($recipt->customer_name); ?></a>
        </dd>
        <?php else: ?>
        <dd><?php echo e($recipt->customer_name); ?></dd>
        <?php endif; ?>
    </div>

    <div class="col-sm-6 col-md-4">
        <dt><?php echo app('translator')->get('NUIT'); ?></dt>
        <dd><?php echo e($recipt->customer_nuit); ?></dd>
    </div>
</dl>

<?php echo $__env->make('sales.receipt.show.parts.mini.btn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<div class="row">
    <div class="table-responsive">
        <table class="table table-sm table-body table-bordered my-2">
            <thead class="">
                <tr>
                    <th class="text-left;"><?php echo app('translator')->get('Metodo de pagamento'); ?></th>
                    <th class="text-left;"><?php echo app('translator')->get('Banco'); ?></th>
                    <th class="text-left"><?php echo app('translator')->get('Número de documento bancário'); ?></th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td class="text-left"><?php echo e($recipt->paymentMethod->name); ?></td>
                    <td class="text-left"><?php echo e($recipt->bankPayment()->exists()?$recipt->bankPayment->bank_name: ''); ?>

                    </td>
                    <td class="text-left"><?php echo e($recipt->bankPayment()->exists()?$recipt->bankPayment->document_nr: ''); ?>

                    </td>
                </tr>
            </tbody>
        </table>
    </div>
</div>


<div class="row">
    <div class="table-responsive">
        <table class="table table-sm table-body table-bordered my-1">
            <thead class="">
                <tr>
                    <th class="text-left;"><?php echo app('translator')->get('Documento'); ?></th>
                    <th class="text-left;"><?php echo app('translator')->get('Data de Emissão'); ?></th>
                    <th class="text-center"><?php echo app('translator')->get('Valor total'); ?></th>
                    <th class="text-center"><?php echo app('translator')->get('Valor pago'); ?></th>
                    <th class="text-center"><?php echo app('translator')->get('Valor pendente'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $recipt->recieptItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <?php if($item->mutate()): ?>
                        <td class="text-left"><?php echo e($item->mutate()->code); ?></td>
                        <td class="text-left"><?php echo e($item->mutate()->validated_at->format('d/m/Y H:i')); ?></td>
                        <td class="text-right"><?php echo e(number_format($item->mutate()->totalAmount(),  2)); ?></td>
                    <?php endif; ?>

                    <?php if($item->mutatebydelivery()): ?>
                        <td class="text-left"><?php echo e($item->mutatebydelivery()->code); ?></td>
                        <td class="text-left"><?php echo e($item->mutatebydelivery()->validated_at->format('d/m/Y H:i')); ?></td>
                        <td class="text-right"><?php echo e(number_format($item->mutatebydelivery()->totalAmount(),  2)); ?></td>
                    <?php endif; ?>

                    <td class="text-right"><?php echo e(number_format($item->totalAmount(), 2)); ?></td>
                    <td class="text-right"><?php echo e(number_format($item->pending, 2)); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>

<?php if($recipt->obs !=null): ?>

<div class="row">
    <div class="col-12 table-responsive">
        <p class="text-justify text-xs"><span class="text-bold">OBS: </span> <?php echo e($recipt->obs); ?></p>
    </div>
</div>
<?php endif; ?>
<div class="row">
    <div class="w-50 float-left mt-2">
        <table class="table  table-sm">
            <thead>
                <tr>
                    <td colspan="4"><b></b>
                    </td>
                </tr>

            </thead>
            <tbody>

            </tbody>
        </table>
    </div>
    <div class="w-50 float-right mt-2">
        <table class="table table-sm">
            <tbody>
                <tr class="">
                    <td><?php echo app('translator')->get('Total usado'); ?></td>
                    <td class="text-right"><?php echo e(number_format($recipt->recieptItems()->sum('amount'),2)); ?></td>
                </tr>
                <tr class="">
                    <td><?php echo app('translator')->get('Total adiantado'); ?></td>
                    <td class="text-right"><?php echo e(number_format($recipt->customerAdvance()->sum('amount'), 2)); ?></td>
                </tr>

                <tr class="">
                    <td><?php echo app('translator')->get('Total pago'); ?></td>
                    <td class="text-right"><?php echo e(number_format($recipt->amount, 2)); ?></td>
                </tr>
            </tbody>
        </table>
    </div>
</div>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/sales/receipt/show/parts/mini/details.blade.php ENDPATH**/ ?>