<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title"><?php echo app('translator')->get('Informações da venda'); ?></h3>
                </div>
                <div class="card-body">
                    <form role="form" id="create-receipt">
                        <div class="row">
                            <div class="form-group col-sm-4">
                                <label for="gender"><?php echo app('translator')->get('Cliente'); ?></label>
                                <select class="selectpicker form-control" data-style="btn-outline-primary" data-size="4"
                                    data-live-search="true" name="customer">
                                    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($customer->id); ?>" data-tokens="<?php echo e($customer->code); ?>">
                                        <?php echo e($customer->name); ?> </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="form-group col-sm-2">
                                <label for="nuit"><?php echo app('translator')->get('NUIT'); ?></label>
                                <input type="text" name="nuit" class="form-control" id="nuit" placeholder="1500"
                                    value="0">
                            </div>

                            <div class="form-group col-sm-2">
                                <label for="advance"><?php echo app('translator')->get('Adiantamento Disponível'); ?></label>
                                <input type="text" disabled name="advance" class="form-control" id="advance" placeholder="1"
                                    value="0">
                            </div>

                            <div class="form-group col-sm-4">
                                <label for="amount"><?php echo app('translator')->get('Montante a pagar'); ?></label>
                                <input type="text" name="amount" class="form-control" id="amount"
                                    placeholder="1500">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <button type="submit"
                                    class="btn btn-sm btn-outline-primary save"><?php echo app('translator')->get('Pesquisar faturas'); ?></button>
                                <button type="button"
                                    class="btn btn-sm btn-outline-success d-none saved"><?php echo app('translator')->get('Pesquisa terminada'); ?></button>
                                <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                                        class="fa fa-spinner fa-spin fa-circle-notch"
                                        aria-hidden="true"></i><?php echo app('translator')->get('Pesquisando'); ?></button>
                                <button type="button"
                                    class="btn btn-sm btn-outline-danger d-none error"><?php echo app('translator')->get('Erro'); ?></button>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startSection('plugins.JqueryValidation', true); ?>
<?php $__env->startSection('plugins.BootstrapSwitch', true); ?>
<?php $__env->startSection('plugins.Sweetalert2', true); ?>
<?php $__env->startSection('plugins.SelectPicker', true); ?>

<?php $__env->startPush('js'); ?>
<script type="text/javascript">
    $(document).ready(function () {
        $.validator.setDefaults({
            submitHandler: getDocuments
        });

        $('#create-receipt').validate({
            rules: {
                amount: {
                    number:true,
                    min: 0
                },

            },
            messages: {
                quantity: {
                    required: 'Este campo é obrigatório',
                    min: 'Deve ser no mínimo zero'
                },
                discount: {
                    min: 'Deve ser no mínimo zero'
                },
            },
            errorElement: 'span',
            errorPlacement: function (error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight: function (element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });
    });


    $('select[name="customer"]').change(checkSelectedOption);
    $('input[name="amount"]').keypress(checkSelectedOption);

    $('form#create-receipt input[name="amount"]').on('keyup', checkSelectedOption);



    var customers = null;
    $(document).ready(getCustomers);
    function getCustomers() {
        $.ajax({
            type: "GET",
            url: "<?php echo e(URL::signedRoute('api.customer.index')); ?>",
            ...ajaxSettings,
            beforeSend: () => {
                $('form#create-receipt').hide();
            },
            statusCode: {
                401: (response) => {
                    $.ajax({
                        url: "<?php echo e(URL::signedRoute('web.system.exit')); ?>",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
            },
            success: function (response) {
                $('form#create-receipt').show();
                customers = response.data;
                checkSelectedOption();
            }
        });
    }

    function checkSelectedOption() {
        handlebar.init([]);
        let amount = $('form#create-receipt input[name="amount"]').val()
        $('input[name="amount"').attr('value', amount)

        const items = customers;
        const value = $('select[name="customer"]').val();

        let searcher = new Searchable(items)

        let customer = searcher.data(value);
        if (customer) {
            render(customer)
        }
    }

    function render(customer) {
        $('input[name="nuit"]').val(customer.nuit);
        $('input[name="advance"]').val(customer.advance);
    }

    function getDocuments() {
        const Toast = Swal.mixin({
            toast: true,
            position: 'top-end',
            showConfirmButton: false,
            timer: 3000
        });

        let data = $('form#create-receipt').serializeArray();

        $.ajax({
            ...ajaxSettings,
            method: 'POST',
            url: "<?php echo e(URL::signedRoute('api.customer.search.bills')); ?>",
            data: data,
            beforeSend: function () {
                $('form#create-receipt button.save').addClass('d-none');
                $('form#create-receipt button.saved').addClass('d-none');
                $('form#create-receipt button.error').addClass('d-none');
                $('form#create-receipt button.saving').removeClass('d-none');
            },
            statusCode: {
                200: function (response) {
                    Toast.fire({
                        type: 'success',
                        title: '<?php echo app('translator')->get("Search finished"); ?>.'
                    })

                    $('form#create-receipt button.save').removeClass('d-none');
                    $('form#create-receipt button.saved').addClass('d-none');
                    $('form#create-receipt button.saving').addClass('d-none');
                    $('form#create-receipt button.error').addClass('d-none');
                    documents = response.data
                    handlebar.init(response.data);
                },
                401: (response) => {

                    Toast.fire({
                        type: 'error',
                        title: '<?php echo app('translator')->get("Volte a fazer o login"); ?>.'
                    })

                    $.ajax({
                        url: "<?php echo e(URL::signedRoute('web.system.exit')); ?>",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
                403: () => {
                    reload();
                },
                422: (response) => {
                    Toast.fire({
                        type: 'error',
                        title: '<?php echo app('translator')->get("Verifique os dados inseridos e submeta outra vez"); ?>.'
                    })

                    $('form#create-receipt button.save').removeClass('d-none');
                    $('form#create-receipt button.saved').addClass('d-none');
                    $('form#create-receipt button.saving').addClass('d-none');
                    $('form#create-receipt button.error').addClass('d-none');
                },
            },
            error: (response) => {
                $('form#create-receipt button.save').addClass('d-none');
                $('form#create-receipt button.saved').addClass('d-none');
                $('form#create-receipt button.saving').addClass('d-none');
                $('form#create-receipt button.error').removeClass('d-none');
                setTimeout(() => {
                    $('form#create-receipt button.save').removeClass('d-none');
                    $('form#create-receipt button.saved').addClass('d-none');
                    $('form#create-receipt button.saving').addClass('d-none');
                    $('form#create-receipt button.error').addClass('d-none');
                }, 2000)
            }
        });
    }
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/sales/receipt/create/parts/form.blade.php ENDPATH**/ ?>