<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header border-transparent">
                    <h3 class="card-title">
                        <?php echo app('translator')->get('Resultados do inventário'); ?>
                    </h3>

                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                        <button type="button" class="btn btn-tool" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
                <div id="table" class="card-body">

                </div>
            </div>

        </div>
    </div>
</div>

<script id="table-template" type="text/x-handlebars-template">
    <table class="sb-datatable export excel table table-bordered table-striped display compact">
        <thead>
            <tr>
                <th><?php echo app('translator')->get('Code'); ?></th>
                <th><?php echo app('translator')->get('Produto'); ?></th>
                <th><?php echo app('translator')->get('Ref/Descr'); ?></th>
                <th><?php echo app('translator')->get('Preço'); ?></th>
                <th><?php echo app('translator')->get('Armazem'); ?></th>
                <th><?php echo app('translator')->get('Saldo'); ?></th>
                <th><?php echo app('translator')->get('Custo total'); ?></th>
                <th><?php echo app('translator')->get('Fornecedor'); ?></th>
                <th><?php echo app('translator')->get('Ultima entrada'); ?></th>
                
                <th><?php echo app('translator')->get('Usuário'); ?></th>
            </tr>
        </thead>
        <tbody>
        {{#each items }}
            <tr>
                <td>{{ this.code }}</td>
                <td>{{ this.saleable }}</td>
                <td>{{ this.description }}</td>
                <td>{{ this.price }}</td>
                <td>{{ this.warehouse }}</td>
                <td>{{ this.balance }}</td>
                <td>{{ this.coast }}</td>
                <td>{{ this.provider }}</td>
                <td>{{ this.validated_at }}</td>
                
                <td>{{ this.user }}</td>
            </tr>
        {{/each}}

        </tbody>
    </table>
</script>

<?php $__env->startPush('js'); ?>
<script type="text/javascript">
    let handlebar = {
        init: function (list) {
            this.cacheDOM();
            this.render(list);
        },
        cacheDOM: function () {
            this.$tableContainer = $('#table');
        },
        render: function (list) {
            var template = Handlebars.compile($("#table-template").html());
            var context = {
                'items': list
            };
            var html = template(context);
            this.$tableContainer.html(html);

            initDatatable();

            if (list.length) {
                this.$tableContainer.parents('.card').show();
            } else {
                this.$tableContainer.parents('.card').hide();
            }
        },
    };

</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/stock/stockmove/inventory/parts/salebles.blade.php ENDPATH**/ ?>