<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title"><?php echo app('translator')->get('Informações da venda'); ?></h3>
                </div>
                <div class="card-body">
                    <form role="form" id="create-delivery_note-sale">
                        <div class="row">
                            <div class="form-group col-sm-4">
                                <label for="gender"><?php echo app('translator')->get('Produto'); ?></label>
                                <select class="selectpicker form-control" data-style="btn-outline-primary" data-size="4"
                                    data-live-search="true" name="saleable">
                                    <option value="" data-tokens=""><?php echo app('translator')->get('Diversos'); ?></option>

                                    <?php $__currentLoopData = $saleables; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $saleable): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($saleable->id); ?>" data-tokens="<?php echo e($saleable->code); ?>">
                                        <?php echo e($saleable->name); ?> </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="form-group col-sm-4">
                                <label for="quantity"><?php echo app('translator')->get('Quantidade'); ?></label>
                                <input type="text" name="quantity" class="form-control" id="quantity" placeholder="1"
                                    value="1">
                            </div>

                            <div class="form-group col-sm-4">
                                <label for="warehouse"><?php echo app('translator')->get('Armazem'); ?></label>
                                <select class="selectpicker form-control" data-style="btn-outline-primary" data-size="4"
                                    data-live-search="true" name="warehouse">
                                    

                                    <?php $__currentLoopData = $warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warehouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($warehouse->id); ?>" data-tokens="<?php echo e($warehouse->name); ?>">
                                        <?php echo e($warehouse->name); ?> </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="form-group col-sm-4">
                                <label for="unit_amount"><?php echo app('translator')->get('Preço unitário'); ?></label>
                                <input type="text" name="unit_amount" class="form-control" id="unit_amount"
                                    placeholder="1500">
                            </div>

                            <div class="form-group col-sm-4">
                                <label for="discount"><?php echo app('translator')->get('Desconto'); ?></label>
                                <input type="text" name="discount" class="form-control" id="discount" placeholder="1500"
                                    value="0">
                            </div>


                            <div class="form-group col-sm-4">
                                <label for="sale_name"><?php echo app('translator')->get('Nome'); ?></label>
                                <input type="text" name="sale_name" class="form-control" id="sale_name"
                                    placeholder="Nome alternativo">
                            </div>

                            <div class="form-group col-sm-4">
                                <label for="sale_code"><?php echo app('translator')->get('Codigo'); ?></label>
                                <input type="text" name="sale_code" class="form-control" id="sale_code"
                                    placeholder="Codigo alternativo">
                            </div>

                            <div class="form-group col-sm-4">
                                <label for="vat_tax"><?php echo app('translator')->get('IVA'); ?></label>
                                <input type="text" name="vat_tax" class="form-control" id="vat_tax"
                                    placeholder="Iva alternativo">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <button type="submit"
                                    class="btn btn-sm btn-outline-primary save"><?php echo app('translator')->get('Adicionar'); ?></button>
                                <button type="button"
                                    class="btn btn-sm btn-outline-success d-none saved"><?php echo app('translator')->get('Adicionado'); ?></button>
                                <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                                        class="fa fa-spinner fa-spin fa-circle-notch"
                                        aria-hidden="true"></i><?php echo app('translator')->get('Adicionando'); ?></button>
                                <button type="button"
                                    class="btn btn-sm btn-outline-danger d-none error"><?php echo app('translator')->get('Erro'); ?></button>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startSection('plugins.JqueryValidation', true); ?>
<?php $__env->startSection('plugins.BootstrapSwitch', true); ?>
<?php $__env->startSection('plugins.Sweetalert2', true); ?>
<?php $__env->startSection('plugins.SelectPicker', true); ?>
<?php $__env->startPush('js'); ?>
<script type="text/javascript">
    $(document).ready(function () {
    $.validator.setDefaults({
        submitHandler: saveCompanyData
    });

    $('#create-delivery_note-sale').validate({
        rules: {
            quantity: {
                required: true,
                min: 0
            },
            discount: {
                min: 0
            },
        },
        messages: {
            quantity: {
                required: 'Este campo é obrigatório',
                min: 'Deve ser no mínimo zero'
            },
            discount: {
                min: 'Deve ser no mínimo zero'
            },
        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
            $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
            $(element).removeClass('is-invalid');
        }
    });
});

$(document).ready(checkSelectedOption);

$('select[name="saleable"]').change(checkSelectedOption);

function checkSelectedOption() {
    const items = JSON.parse('<?php echo $saleables; ?>')
    const value =  $('select[name="saleable"]').val();

    let searcher = new Searchable(items)

    let saleable = searcher.data(value);
    if (saleable) {
        render(saleable)
    }
}

function render(saleable) {
    $('input[name="unit_amount"]').val(saleable.price);
    $('input[name="sale_name"]').val(saleable.name);
    $('input[name="sale_code"]').val(saleable.code);
    $('input[name="vat_tax"]').val(saleable.vat_scheme.tax);
}

function saveCompanyData() {
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
    });

    let data = $('form#create-delivery_note-sale').serializeArray();

    console.log(data);

    $.ajax({
        ...ajaxSettings,
        method: 'POST',
        url: "<?php echo e(URL::signedRoute('api.sales.delivery_note.item.store', ['delivery_note' => $delivery_note->id])); ?>",
        data: data,
        beforeSend: function () {
            $('form#create-delivery_note-sale button.save').addClass('d-none');
            $('form#create-delivery_note-sale button.saved').addClass('d-none');
            $('form#create-delivery_note-sale button.error').addClass('d-none');
            $('form#create-delivery_note-sale button.saving').removeClass('d-none');
        },
        statusCode: {
            201: function (response) {
                Toast.fire({
                    type: 'success',
                    title: '<?php echo app('translator')->get("Item added"); ?>.'
                })

                $('form#create-delivery_note-sale button.save').removeClass('d-none');
                $('form#create-delivery_note-sale button.saved').addClass('d-none');
                $('form#create-delivery_note-sale button.saving').addClass('d-none');
                $('form#create-delivery_note-sale button.error').addClass('d-none');
                handlebar.init(response.body.items);

                $('input[name="quantity"]').val(null);
                $('input[name="discount"]').val(0);

                $.each(response.alerts, function (indexInArray, valueOfElement) {
                    // Toast.fire({
                    //     type: 'warning',
                    //     title: valueOfElement,
                    // })

                    Swal.fire({
                        position: 'top-end',
                        icon: 'error',
                        color: '#716add',
                        title: valueOfElement,
                        showConfirmButton: true,
                        timer: 3500
                      })
                });

            },
            401: (response) => {

                Toast.fire({
                    type: 'error',
                    title: '<?php echo app('translator')->get("Volte a fazer o login"); ?>.'
                })

                $.ajax({
                    url: "<?php echo e(URL::signedRoute('web.system.exit')); ?>",
                    dataType: "HTML",
                    success: function (response) {
                        setTimeout(() => {
                            reload();
                        }, 1500);
                    }
                });
            },
            403: () => {
                reload();
            },
            422: (response) => {
                Toast.fire({
                    type: 'error',
                    title: '<?php echo app('translator')->get("Verifique os dados inseridos e submeta outra vez"); ?>.'
                })

                $('form#create-delivery_note-sale button.save').removeClass('d-none');
                $('form#create-delivery_note-sale button.saved').addClass('d-none');
                $('form#create-delivery_note-sale button.saving').addClass('d-none');
                $('form#create-delivery_note-sale button.error').addClass('d-none');
            },
        },
        error: (response) => {
            $('form#create-delivery_note-sale button.save').addClass('d-none');
            $('form#create-delivery_note-sale button.saved').addClass('d-none');
            $('form#create-delivery_note-sale button.saving').addClass('d-none');
            $('form#create-delivery_note-sale button.error').removeClass('d-none');
            setTimeout(() => {
                $('form#create-delivery_note-sale button.save').removeClass('d-none');
                $('form#create-delivery_note-sale button.saved').addClass('d-none');
                $('form#create-delivery_note-sale button.saving').addClass('d-none');
                $('form#create-delivery_note-sale button.error').addClass('d-none');
            }, 2000)
        }
    });
}
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/sales/delivery_note/create/parts/form.blade.php ENDPATH**/ ?>