<form role="form" id="edit-saleable">
    <div class="row">
        <div class="form-group col-sm-4">
            <label for="name"><?php echo app('translator')->get('Nome'); ?></label>
            <input type="text" name="name" class="form-control" id="name" placeholder="Mouse Optico"
                value="<?php echo e($saleable->name); ?>">
        </div>

        <div class="form-group col-sm-4">
            <label for="code"><?php echo app('translator')->get('Codigo'); ?></label>
            <input type="text" name="code" class="form-control" id="code" placeholder="125896321"
                value="<?php echo e($saleable->code); ?>">
        </div>

        <div class="form-group col-sm-4">
            <label for="vat_scheme"><?php echo app('translator')->get('Regime de IVA'); ?></label>
            <select name="vat_scheme" class="form-control select2bs4" style="width: 100%;"
                data-placeholder="<?php echo app('translator')->get('Seleciona regime da empresa'); ?>">
                <?php $__currentLoopData = $vatschemes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $scheme): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($scheme->id); ?>" <?php echo e($scheme->is($saleable->vatScheme)? 'selected': ''); ?>>
                    <?php echo e($scheme->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="form-group col-sm-4">
            <label for="sale_unit"><?php echo app('translator')->get('Unidade de venda'); ?></label>
            <select name="sale_unit" class="form-control select2bs4" style="width: 100%;"
                data-placeholder="<?php echo app('translator')->get('Seleciona a unidade de venda'); ?>">
                <?php $__currentLoopData = $saleunits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($unit->id); ?>" <?php echo e($unit->is($saleable->saleUnit)? 'selected': ''); ?>><?php echo e($unit->name); ?>

                </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="form-group col-sm-4">
            <label for="price"><?php echo app('translator')->get('Preço unitário'); ?></label>
            <input type="text" name="price" class="form-control" id="price" placeholder="15000"
                value="<?php echo e($saleable->price); ?>">
        </div>

        <div class="form-group col-sm-4">
            <label for="price"><?php echo app('translator')->get('Usa Stock'); ?></label>
            <br>

            <input type="checkbox" class="bootstrap-switch form-control" name="stockable" <?php echo $saleable->is_stockable?
            'checked': ''; ?> data-bootstrap-switch
            data-off-color="danger" data-on-color="success">
        </div>

        <div class="form-group col-sm-12">
            <label for="description"><?php echo app('translator')->get('Descrição'); ?></label>
            <textarea class="form-control" name="description" id="description"
                rows="3"><?php echo e($saleable->description); ?></textarea>
        </div>

        <div class="form-group col-sm-12">
            <label for="gender"><?php echo app('translator')->get('Categorias'); ?></label>
            <select class="select2bs4" name="categories[]" multiple="multiple"
                data-placeholder="<?php echo app('translator')->get('Selecione as categorias do produto'); ?>" style="width: 100%;">
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($category->id); ?>" <?php echo e($saleable->hasCategory($category)? 'selected': ''); ?>>
                    <?php echo e($category->name); ?> </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <button type="submit" class="btn btn-sm btn-outline-primary save"><?php echo app('translator')->get('Salvar'); ?></button>
            <button type="button" class="btn btn-sm btn-outline-success d-none saved"><?php echo app('translator')->get('Salvo'); ?></button>
            <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                    class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i><?php echo app('translator')->get('Salvando'); ?></button>
            <button type="button" class="btn btn-sm btn-outline-danger d-none error"><?php echo app('translator')->get('Erro'); ?></button>
        </div>
    </div>
</form>


<?php $__env->startSection('plugins.JqueryValidation', true); ?>
<?php $__env->startSection('plugins.Select2', true); ?>
<?php $__env->startSection('plugins.Sweetalert2', true); ?>
<?php $__env->startSection('plugins.BootstrapSwitch', true); ?>

<?php $__env->startPush('js'); ?>
<script type="text/javascript">
    $(document).ready(function () {
      $.validator.setDefaults({
        submitHandler: saveCompanyData
      });

      $('#edit-saleable').validate({
        rules: {
            name:{
                required:true,
                minlength:2
            },
            code:{
                required:true,
            },
            price:{
                required:true,
                min:0
            },
            description:{
                required:false,
                minlength:2
            },
        },
        messages: {
            name:{
                required:'Por favor introduza o nome do item',
                minlength:'O nome deve ter no mínimo 2 caracteres'
            },
            code:{
                required:'Introduza o codigo do produto',
            },
            price:{
                required: 'introduza o preço do item.',
                min: 'O preço minimo deve se 0'
            },
            description:{
                minlength:'Por favor introduza o telefone da empresa',
            },
        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
          error.addClass('invalid-feedback');
          element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
          $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
          $(element).removeClass('is-invalid');
        }
      });
    });

    $(document).ready(function () {
        $('.select2bs4').select2({
            theme: 'bootstrap4'
        })
    });


    function saveCompanyData(){
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
      });


        let data = $('form#edit-saleable').serializeArray();

        $.ajax({
            ...ajaxSettings,
            method:'PUT',
            url: "<?php echo e(URL::route('api.stock.saleable.update', ['saleable'=>$saleable->id])); ?>",
            data: data,
            beforeSend: function(){
              $('form#edit-saleable button.save').addClass('d-none');
              $('form#edit-saleable button.saved').addClass('d-none');
              $('form#edit-saleable button.error').addClass('d-none');
              $('form#edit-saleable button.saving').removeClass('d-none');
            },
            statusCode : {
                202: function(response){
                  Toast.fire({
                    type: 'success',
                    title: '<?php echo app('translator')->get("Product has been edited"); ?>.'
                  })

                  $('form#edit-saleable button.save').addClass('d-none');
                  $('form#edit-saleable button.saved').removeClass('d-none');
                  $('form#edit-saleable button.saving').addClass('d-none');
                  $('form#edit-saleable button.error').addClass('d-none');
                    setTimeout(() => {
                        goto(response.url.web);
                    }, 3000)
                },
                401:(response) =>{

                    Toast.fire({
                        type: 'error',
                        title: '<?php echo app('translator')->get("Volte a fazer o login"); ?>.'
                    })

                    $.ajax({
                        url: "<?php echo e(URL::route('web.system.exit')); ?>",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
                422:(response) =>{
                  Toast.fire({
                    type: 'error',
                    title: '<?php echo app('translator')->get("Verifique os dados inseridos e submeta outra vez"); ?>.'
                  })
                },
            },
            error: (response) => {
              $('form#edit-saleable button.save').addClass('d-none');
              $('form#edit-saleable button.saved').addClass('d-none');
              $('form#edit-saleable button.saving').addClass('d-none');
              $('form#edit-saleable button.error').removeClass('d-none');
              setTimeout(() => {
                $('form#edit-saleable button.save').removeClass('d-none');
                $('form#edit-saleable button.saved').addClass('d-none');
                $('form#edit-saleable button.saving').addClass('d-none');
                $('form#edit-saleable button.error').addClass('d-none');
              }, 2000)
            }
        });
    }
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/stock/saleable/show/parts/mini/edit.blade.php ENDPATH**/ ?>