<?php $__env->startSection('plugins.Datatables', true); ?>
<?php $__env->startPush('js'); ?>
<script type="text/javascript">
    $(document).ready(function () {
        initDatatable();
    });
</script>
<?php $__env->stopPush(); ?>

<?php
$purchases = $provider->purchases;
?>

<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <a href="<?php echo e(URL::signedRoute('web.stock.providers.purchases.create', ['provider'=> $provider->id ])); ?>"
                class="btn btn-sm btn-outline-primary"><?php echo app('translator')->get('Nova compra'); ?></a>

            <a href="<?php echo e(URL::signedRoute('web.stock.providers.expenses.create', ['provider'=> $provider->id ])); ?>"
                class="btn btn-sm btn-outline-primary"><?php echo app('translator')->get('Registro de faturas'); ?></a>
        </h3>
    </div>
    <!-- /.card-header -->
    <div class="card-body">
        <table id="table" class="sb-datatable table table-bordered table-striped display compact">
            <thead>
                <tr>
                    <th><?php echo app('translator')->get('Data'); ?></th>
                    <th><?php echo app('translator')->get('Documento'); ?></th>
                    <th><?php echo app('translator')->get('Total'); ?></th>
                    <th><?php echo app('translator')->get('Total Pago'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $purchases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $purchase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr ondblclick="goto('<?php echo e(URL::signedRoute('web.stock.providers.purchases.show', ['provider'=> $purchase->provider->id , 'purchase'=>$purchase->id])); ?>')"
                    class="cursor-pointer">
                    <td><?php echo e($purchase->validated_at?$purchase->validated_at->format('Y/m/d'): ''); ?></td>
                    <td><?php echo e($purchase->name); ?></td>
                    <td><?php echo e(number_format($purchase->totalAmount(), 2)); ?></td>
                    <td><?php echo e(number_format($purchase->totalAmountPaid(), 2)); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </tbody>
            <tfoot>
                <tr>
                    <th><?php echo app('translator')->get('Data'); ?></th>
                    <th><?php echo app('translator')->get('Documento'); ?></th>
                    <th><?php echo app('translator')->get('Total'); ?></th>
                    <th><?php echo app('translator')->get('Total Pago'); ?></th>
                </tr>
            </tfoot>
        </table>
    </div>
</div><?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/stock/provider/purchases/list/parts/table.blade.php ENDPATH**/ ?>