<?php $__env->startSection('title', 'Tools List'); ?>

<?php $__env->startSection('content_header'); ?>
<div class="container-fluid">
    <div class="row mb-2">
        <div class="col-sm-6">
            <h1><?php echo app('translator')->get('Ferramentas de Inventário'); ?></h1>
        </div>
        
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('plugins.Handlebars', true); ?>
<?php $__env->startSection('plugins.Datatables', true); ?>
<?php $__env->startSection('plugins.DatatablesExport', true); ?>

<?php $__env->startSection('plugins.JqueryValidation', true); ?>
<?php $__env->startSection('plugins.Sweetalert2', true); ?>
<?php $__env->startSection('plugins.SelectPicker', true); ?>

<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <div class="row">
        <section class="col-md-4 connectedSortable">
            <div class="small-box bg-info">
                <div class="inner">
                    <h2><?php echo app('translator')->get('Verificador'); ?> <?php echo app('translator')->get('Inventário'); ?></h2>
                    <p><?php echo app('translator')->get('Verifique e imprima o inevatário de acordo com as categorias existentes (Docx, Excel, Pdf)'); ?></p>
                </div>
                <div class="icon">
                    <i class="fa fa-university" aria-hidden="true"></i>
                </div>
                <a href="<?php echo e(route('web.stock.inventory')); ?>" class="small-box-footer "> <?php echo app('translator')->get('Verificar'); ?> <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>

        </section>

           <section class="col-md-4 connectedSortable">
            <div class="small-box bg-warning">
                <div class="inner">
                    <h2><?php echo app('translator')->get('Sotck por quantidade'); ?></h2>
                    <p><?php echo app('translator')->get('Verificar produtos com stock baixos ao nivel que desejas, por quantidade'); ?></p>
                </div>
                <div class="icon">
                   <i class="fa fa-binoculars" aria-hidden="true"></i>
                </div>
                <a href="<?php echo e(route('web.stock.tools.stock')); ?>" class="small-box-footer "> <?php echo app('translator')->get('Verificar'); ?> <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>

           </section>

           <section class="col-md-4 connectedSortable">
            <div class="small-box bg-success">
                <div class="inner">
                    <h3><?php echo app('translator')->get('verificador de Expirados'); ?></h3>
                    <p><?php echo app('translator')->get('Produtos fora do prazo, ou mesmo dentro'); ?><br></p>
                </div>
                <div class="icon">
                   <i class="fa fa-thermometer-full" aria-hidden="true"></i>
                </div>
                <a href="<?php echo e(route('web.stock.tools.expiredsaleable')); ?>" class="small-box-footer "> <?php echo app('translator')->get('Verificar'); ?> <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>

        </section>
    </div>

    <div >
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                <h3><?php echo app('translator')->get('Armazéns'); ?></h3>
                </h3>
            </div>
            <div class="card-body">
                <table id="table" class="sb-datatable table table-bordered table-striped display compact">
                    <thead>
                        <tr>
                            <th><?php echo app('translator')->get('Nome'); ?></th>
                            <th><?php echo app('translator')->get('Produtos'); ?> Qty</th>
                            <th><?php echo app('translator')->get('Responsável'); ?></th>
                            <th><?php echo app('translator')->get('Contacto'); ?></th>
                        </tr>
                    </thead>
                    <tbody>

                 <?php $__currentLoopData = $warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warehouse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr ondblclick="goto('<?php echo e(URL::signedRoute('web.stock.warehouse.show', ['warehouse'=>$warehouse->id])); ?>')"
                    class="cursor-pointer">
                    <td><?php echo e($warehouse->name); ?></td>
                    <td><?php echo e($warehouse->saleables()->count()); ?></td>
                    <td><?php echo e($warehouse->responsible); ?></td>
                    <td><?php echo e($warehouse->contact); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th><?php echo app('translator')->get('Nome'); ?></th>
                            <th><?php echo app('translator')->get('Produtos'); ?></th>
                            <th><?php echo app('translator')->get('Responsável'); ?></th>
                            <th><?php echo app('translator')->get('Contacto'); ?></th>
                        </tr>
                    </tfoot>
                </table>
            </div>

        </div>
    </div>
</div>


<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/stock/stockmove/inventory/toolslist/index.blade.php ENDPATH**/ ?>