<form role="form" class="d-inline" id="finalize-moves">
    <button type="submit" class="btn btn-sm btn-outline-primary save"><?php echo app('translator')->get('Finalizar'); ?></button>
    <button type="button" class="btn btn-sm btn-outline-success d-none saved"><?php echo app('translator')->get('Finalizado'); ?></button>
    <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
            class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i><?php echo app('translator')->get('Finalizando'); ?></button>
    <button type="button" class="btn btn-sm btn-outline-danger d-none error"><?php echo app('translator')->get('Erro'); ?></button>
</form>


<?php $__env->startSection('plugins.JqueryValidation', true); ?>

<?php $__env->startPush('js'); ?>
<script type="text/javascript">
    $(document).ready(function () {
    $.validator.setDefaults({
        submitHandler: finalizeMoves
    });

    $('#finalize-moves').validate({
        rules: {

        },
        messages: {

        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
            $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
            $(element).removeClass('is-invalid');
        }
    });
});


function finalizeMoves() {
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
    });


    let data = $('form#finalize-moves').serializeArray();

    $.ajax({
        ...ajaxSettings,
        method: 'PUT',
        url: "<?php echo e(URL::signedRoute('api.stock.groups.finalize', ['group' => $group->id])); ?>",
        data: data,
        beforeSend: function () {
            $('form#finalize-moves button.save').addClass('d-none');
            $('form#finalize-moves button.saved').addClass('d-none');
            $('form#finalize-moves button.error').addClass('d-none');
            $('form#finalize-moves button.saving').removeClass('d-none');
        },
        statusCode: {
            202: function (response) {

                Toast.fire({
                    type: 'success',
                    title: '<?php echo app('translator')->get("Entradas finalizadas"); ?>.'
                });

                $('form#finalize-moves button.save').addClass('d-none');
                $('form#finalize-moves button.saved').removeClass('d-none');
                $('form#finalize-moves button.saving').addClass('d-none');
                $('form#finalize-moves button.error').addClass('d-none');
                setTimeout(() => {
                    goto('<?php echo e(URL::signedRoute('web.stock.move.index')); ?>')
                }, 3000);
            },
            401: (response) => {

                Toast.fire({
                    type: 'error',
                    title: '<?php echo app('translator')->get("Volte a fazer o login"); ?>.'
                })

                $.ajax({
                    url: "<?php echo e(URL::signedRoute('web.system.exit')); ?>",
                    dataType: "HTML",
                    success: function (response) {
                        setTimeout(() => {
                            reload();
                        }, 1500);
                    }
                });
            },
            403: () => {
                reload();
            },
        },
        error: (response) => {
            $('form#finalize-moves button.save').addClass('d-none');
            $('form#finalize-moves button.saved').addClass('d-none');
            $('form#finalize-moves button.saving').addClass('d-none');
            $('form#finalize-moves button.error').removeClass('d-none');
            setTimeout(() => {
                $('form#finalize-moves button.save').removeClass('d-none');
                $('form#finalize-moves button.saved').addClass('d-none');
                $('form#finalize-moves button.saving').addClass('d-none');
                $('form#finalize-moves button.error').addClass('d-none');
            }, 2000)
        }
    });
}
</script>
<?php $__env->stopPush(); ?><?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/stock/transfers/parts/mini/finalize-btn.blade.php ENDPATH**/ ?>