<!DOCTYPE html>
<html>

<head>
    <script type="text/javascript">
        window.print();
        window.onafterprint = home;

        function home() {
            window.location.assign("<?php echo e(URL::signedRoute('web.stock.inventory')); ?>");
        }
    </script>

    <style type="text/css">
        @font-face {
            font-family: 'merchant_copy_doublesizeRg';
            font-weight: normal;
            font-style: normal;
        }
    </style>
    <style type="text/css">
        * {
            margin-right: 1px;
            padding: 0px;
            /* font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif */
            font-family: 'merchant_copy_doublesizeRg';
        }


        body {
            font-size: 11px;
        }

        table {
            border: 1px solid #ccc;
            width: 100%;
            text-align: center;
        }

        table tr {
            border: 1px solid #ccc;
        }

        table tfoot td {
            /* border-left: 2px solid; */
            border-top: 2px solid;
        }
    </style>

</head>

<?php
$company = $warehouse->company;
?>

<body>
    <div style="margin: auto; width: 200px; text-align: center">
        <img src="<?php echo e($company->logoPhoto()); ?>" width="80px" height="80px" style="object-fit: scale-down;"><br>
        <b><?php echo e($company->name); ?></b><br>
        <b><?php echo app('translator')->get('Endereco'); ?>: </b> <?php echo e($company->address); ?><br>
        <b><?php echo app('translator')->get('Nuit'); ?>: </b> <?php echo e($company->nuit); ?><br>
        <b> <?php echo app('translator')->get('Inventário armazem'); ?> <?php echo e($warehouse->name); ?></b>

    </div>

    <div style="margin-top: 10px">
        <div style="width: 49%; float: left; text-align: left"><b>Data: </b>
            <?php echo e((new Carbon\Carbon())->format('Y-m-d H:i')); ?></div>
    </div>

    <div style="margin-top: 20px;">
        <table>
            <thead>
                <tr>
                    
                    <th>&nbsp;&nbsp;</th>
                    <th>&nbsp;&nbsp;</th>
                </tr>
            </thead>
            <tbody>

                <?php $__empty_1 = true; $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                

                <tr>
                    <th style=" text-align: left;">Code</th>
                    <th style=" text-align: left;"><?php echo app('translator')->get('Nome'); ?> :</th>
                    <th style=" text-align: right;">Quantidade</th>
                    <th>&nbsp;&nbsp;</th>
                </tr>
                    <?php $__empty_2 = true; $__currentLoopData = $category->saleables()->whereHas('stockMoves', function($query) use ($warehouse){
                        return $query->whereHas('warehouse', function($subquery)  use ($warehouse){
                            return $subquery->where('warehouses.id', $warehouse->id);
                        });

                    })->orderBy('name')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $saleable): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                        <?php
                            $move = $saleable->lastStockMove($warehouse);
                            if (!$move) {
                               continue;
                            }
                        ?>

                        <tr>
                            <td style=" text-align: left;"><?php echo e($saleable->code); ?></td>
                            <td style=" text-align: left;"><?php echo e($saleable->name); ?></td>
                            <td style=" text-align: right;"><?php echo e(number_format($move->balance, 2)); ?></td>
                            <td>&nbsp;&nbsp;</td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>

                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                <?php endif; ?>

            </tbody>
        </table>
    </div>

    <div style="margin-top: 5px">
        <div style="width: 100%; float: left; text-align: left">
            Obrigado<br/>Volte sempre

        </div>
    </div>


    <div style="margin-top: 20px">
        <div style="width: 100%; float: left; text-align: left">
            <?php echo e(config('app.authors.name')); ?><br />
            Operador: <i><?php echo e(request()->user()->name); ?></i>
        </div>
    </div>
</body>
<html>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/stock/stockmove/inventory/thermal/index.blade.php ENDPATH**/ ?>