<dl class="row">

    <div class="col-sm-6 col-md-4">
        <dt><?php echo app('translator')->get('Documento'); ?></dt>
        <dd><?php echo e($deliveryNote->name()); ?></dd>
    </div>
    <div class="col-sm-6 col-md-4">
        <dt><?php echo app('translator')->get('Data de emissão'); ?></dt>
        <dd><?php echo e($deliveryNote->issueDate()); ?></dd>
    </div>
    <div class="col-sm-6 col-md-4">
        <dt><?php echo app('translator')->get('Prazo de pagamento'); ?></dt>
        <dd><?php echo e($deliveryNote->dueDate()); ?></dd>
    </div>

    <div class="col-sm-6 col-md-4">
        <dt><?php echo app('translator')->get('Operador'); ?></dt>
        <dd><?php echo e($deliveryNote->operator()); ?></dd>
    </div>
    <div class="col-sm-6 col-md-4">
        <dt><?php echo app('translator')->get('Valor total'); ?></dt>
        <dd><?php echo e(number_format($deliveryNote->totalAmount(), 2)); ?></dd>
    </div>


    <?php if(false): ?>

    <div class="col-sm-6 col-md-4">
        <dt><?php echo app('translator')->get('Valor Pendente'); ?></dt>
        <dd><?php echo e(number_format($deliveryNote->pendingAmount(), 2)); ?></dd>
    </div>

    <?php endif; ?>

</dl>

<dl class="row">
    <div class="col-sm-6 col-md-4">
        <dt><?php echo app('translator')->get('Cliente'); ?></dt>
        <?php if($deliveryNote->customer): ?>
        <dd><a href="<?php echo e(URL::route('web.customer.show', ['customer'=>  $deliveryNote->customer->id])); ?>"><?php echo e($deliveryNote->customer_name); ?></a>
        </dd>
        <?php else: ?>
        <dd><?php echo e($deliveryNote->customer_name); ?></dd>
        <?php endif; ?>
    </div>

    <div class="col-sm-6 col-md-4">
        <dt><?php echo app('translator')->get('NUIT'); ?></dt>
        <dd><?php echo e($deliveryNote->customer_nuit); ?></dd>
    </div>
    <div class="col-sm-6 col-md-4">
        <dt><?php echo app('translator')->get('Valor'); ?> &nbsp; <?php echo app('translator')->get('Faturado'); ?></dt>
        <?php if($deliveryNote->invoices->first() !=null): ?>
                <dd style="backgroundcolor: red"><?php echo e($deliveryNote->invoices->first()->totalAmount()); ?></dd>
        <?php endif; ?>

    </div>

</dl>

<?php echo $__env->make('sales.delivery_note.show.parts.mini.btn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<div class="row">
    <div class="col-12 table-responsive">
        <table class="table table-sm table-body table-bordered my-1 mt-3">
            <thead class="">
                <tr>
                    <th class="text-left;"><?php echo app('translator')->get('Codigo'); ?></th>
                    <th class="text-left;"><?php echo app('translator')->get('Artigo'); ?></th>
                    <th class="text-center"><?php echo app('translator')->get('Preço'); ?></th>
                    <th class="text-center"><?php echo app('translator')->get('Qty'); ?></th>
                    <th class="text-center"><?php echo app('translator')->get('Desconto'); ?></th>
                    <th class="text-center"><?php echo app('translator')->get('IVA'); ?> %</th>
                    <th class="text-center"><?php echo app('translator')->get('Subtotal'); ?></th>
                </tr>
            </thead>
            <tbody>

                <?php $__currentLoopData = $deliveryNote->saleItens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="text-left"><?php echo e($item->sale_code); ?></td>
                    <td class="text-left"><?php echo e($item->sale_name); ?></td>
                    <td class="text-right"><?php echo e(number_format($item->unit_amount, 2)); ?></td>
                    <td class="text-right"><?php echo e(number_format($item->quantity)); ?></td>
                    <td class="text-right"><?php echo e(number_format($item->discount, 2)); ?></td>
                    <td class="text-right"><?php echo e(number_format($item->vat_tax, 2)); ?></td>
                    <td class="text-right"><?php echo e(number_format($item->totalAmount(), 2)); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<?php if($deliveryNote->obs !=null): ?>

<div class="row">
    <div class="col-12 table-responsive">
        <p class="text-justify text-xs"><span class="text-bold">OBS: </span> <?php echo e($deliveryNote->obs); ?></p>
    </div>
</div>
<?php endif; ?>


<div class="row">
    <div class="col-12">
        <div class="w-50 float-left mt-2">
            <table class="table table-bordered table-sm">
                <thead>
                    <tr>
                        <td colspan="4"><b><?php echo app('translator')->get('Resumo de IVA'); ?></b>
                        </td>
                    </tr>
                    <tr>
                        <td class="text-right"><b><?php echo app('translator')->get('Taxa'); ?></b></td>
                        <td class="text-right"><b><?php echo app('translator')->get('Incidência'); ?></b></td>
                        <td class="text-right"><b><?php echo app('translator')->get('Total IVA'); ?></b></td>
                        <td class="text-right"><b><?php echo app('translator')->get('Motivo de isenção'); ?></b></td>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $deliveryNote->vatResume(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="text-right"><?php echo e($item->vat_tax); ?></td>
                        <td class="text-right"><?php echo e(number_format($item->incidence, 2)); ?></td>
                        <td class="text-right"><?php echo e(number_format($item->total, 2)); ?></td>
                        <td></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <div class="w-40 float-right mt-2">
            <table class="table table-sm">
                <tbody>
                    <tr class="">
                        <td><?php echo app('translator')->get('Mercadoria ou serviços'); ?></td>
                        <td class="text-right"><?php echo e(number_format($deliveryNote->groceriesAndServices(),2)); ?></td>
                    </tr>
                    <tr class="">
                        <td><?php echo app('translator')->get('Descontos comerciais'); ?></td>
                        <td class="text-right"><?php echo e(number_format($deliveryNote->commercialDiscount(), 2)); ?></td>
                    </tr>

                    <tr class="">
                        <td><?php echo app('translator')->get('Desconto financeiro'); ?></td>
                        <td class="text-right"><?php echo e(number_format($deliveryNote->financial_discount)); ?></td>
                    </tr>
                    <tr class="">
                        <td><?php echo app('translator')->get('IVA'); ?></td>
                        <td class="text-right"><?php echo e(number_format($deliveryNote->vatResume()->sum('total'), 2)); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo app('translator')->get('Total MZN'); ?></td>
                        <td class="text-right"><?php echo e(number_format($deliveryNote->totalAmount(), 2)); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>

    </div>

</div>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/sales/delivery_note/show/parts/mini/details.blade.php ENDPATH**/ ?>