<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <?php echo $__env->make('sales.invoice.pdf.style', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>
<?php
$company = $recipt->company;
$customer = $recipt->customer;
?>

<body style="font-size: 16px;">
    <div class="container-fluid">
        <div class="float-left w-60 text-left">

            <img src="<?php echo e($company->logoPhoto()); ?>" width="150" style="object-fit: scale-down;" />

            <br><b><?php echo e($company->name); ?></b><br>
            <b><?php echo e($company->nuit); ?></b> <br>
            <?php echo e($company->address); ?><br>
            <?php echo e($company->email); ?><br>
            <?php echo e($company->phone); ?>

            <br>
        </div>

        <div class="float-right w-40 text-right">
            <table class="table table-sm">
                <tbody>
                    <tr>
                        <td class="border-0 text-left"><b><?php echo app('translator')->get('Cliente'); ?> : </b></td>
                        <td class="border-0 text-right"><?php echo e($customer->code); ?></td>
                    </tr>
                    <tr class="border-0 ">
                        <td class="border-0 text-left"><?php echo app('translator')->get('Nome'); ?> </td>
                        <td class="border-0 text-right"><?php echo e($customer->name); ?></td>
                    </tr>
                    <tr class="border-0 ">
                        <td class="border-0 text-left"><?php echo app('translator')->get('NUIT'); ?></td>
                        <td class="border-0 text-right"><?php echo e($customer->nuit); ?></td>
                    </tr>
                    <tr class="border-0 ">
                        <td class="border-0 text-left"><?php echo app('translator')->get('Telefone'); ?></td>
                        <td class="border-0 text-right"><?php echo e($customer->phone); ?></td>
                    </tr>

                    <tr>
                        <td class="border-0 text-right" colspan="2"><?php echo e($customer->address); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>


    <div class="container-fluid">
        <div class="w-50 float-left mt-3">
            <table class="table table-sm">
                <tbody>
                    <tr class="">
                        <td><?php echo app('translator')->get('Documento'); ?></td>
                        <td class="text-right">
                            <b><?php echo app('translator')->get('Recibo'); ?></b>
                        </td>
                    </tr>

                    <tr class="">
                        <td><?php echo app('translator')->get('Moeda'); ?></td>
                        <td class="text-right">MZN</td>
                    </tr>
                    <tr>
                        <td><?php echo app('translator')->get('Data de emissao'); ?></td>
                        <td class="text-right"><?php echo e($recipt->validated_at->format('d/m/Y')); ?></td>
                    </tr>
                    <tr class="">
                        <td><?php echo app('translator')->get('Operador'); ?></td>
                        <td class="text-right"><?php echo e($recipt->user->name); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>



        <div class="w-40 float-right mt-3">
            <table class="table text-bold table-sm text-right">
                <tbody>
                    <tr class="">
                        <td class="border-top-0"><?php echo e($recipt->order()); ?></td>
                    </tr>
                    <tr>
                        <td class="border-top-0"> <?php echo e($recipt->name()); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <div class="container-fluid">

        <div class="table-responsive">
            <table class="table table-sm table-body table-bordered mb-2">
                <thead class="">
                    <tr>
                        <th class="text-left;"><?php echo app('translator')->get('Metodo de pagamento'); ?></th>
                        <th class="text-left;"><?php echo app('translator')->get('Banco'); ?></th>
                        <th class="text-left"><?php echo app('translator')->get('Número de documento bancário'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="text-left"><?php echo e($recipt->paymentMethod->name); ?></td>
                        <td class="text-left"><?php echo e($recipt->bankPayment()->exists()?$recipt->bankPayment->bank_name: ''); ?>

                        </td>
                        <td class="text-left">
                            <?php echo e($recipt->bankPayment()->exists()?$recipt->bankPayment->document_nr: ''); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>


    <div class="container-fluid">

        <div class="table-responsive">
            <table class="table table-sm table-body table-bordered mb-1">
                <thead class="">
                    <tr>
                        <th class="text-left;"><?php echo app('translator')->get('Documento'); ?></th>
                        <th class="text-left;"><?php echo app('translator')->get('Data de Emissão'); ?></th>
                        <th class="text-center"><?php echo app('translator')->get('Valor total'); ?></th>
                        <th class="text-center"><?php echo app('translator')->get('Valor pago'); ?></th>
                        <th class="text-center"><?php echo app('translator')->get('Valor pendente'); ?></th>
                    </tr>
                </thead>
                <tbody>

                    <?php $__currentLoopData = $recipt->recieptItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <?php if($item->mutate()): ?>
                            <td class="text-left"><?php echo e($item->mutate()->code); ?></td>
                            <td class="text-left"><?php echo e($item->mutate()->validated_at->format('d/m/Y H:i')); ?></td>
                            <td class="text-right"><?php echo e(number_format($item->mutate()->totalAmount(),  2)); ?></td>
                        <?php endif; ?>

                        <?php if($item->mutatebydelivery()): ?>
                            <td class="text-left"><?php echo e($item->mutatebydelivery()->code); ?></td>
                            <td class="text-left"><?php echo e($item->mutatebydelivery()->validated_at->format('d/m/Y H:i')); ?></td>
                            <td class="text-right"><?php echo e(number_format($item->mutatebydelivery()->totalAmount(),  2)); ?></td>
                        <?php endif; ?>

                        <td class="text-right"><?php echo e(number_format($item->totalAmount(), 2)); ?></td>
                        <td class="text-right"><?php echo e(number_format($item->pending, 2)); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

           <table class="mt-3" style="display: none">
                <tr>
                    <td><sub><?php echo e(config("app.name")); ?>, <?php echo app('translator')->get('Licença'); ?>
                            <span class="text-bold text-sm"><?php echo e(config("app.finance_dep_global_auth")); ?></span> /
                            <?php echo e(Auth::user()->brunch->daf_auth); ?> </sub></td>
                </tr>
            </table>
        </div>
    </div>

    <div class="container-fluid">
        <div class="w-50 float-left mt-2">
            <table class="table table-bordered table-sm d-none">
                <thead>
                    <tr>
                        <td colspan="4"><b><?php echo app('translator')->get('Resumo de IVA'); ?></b>
                        </td>
                    </tr>
                    <tr>
                        <td class="text-right"><b><?php echo app('translator')->get('Taxa'); ?></b></td>
                        <td class="text-right"><b><?php echo app('translator')->get('Incidência'); ?></b></td>
                        <td class="text-right"><b><?php echo app('translator')->get('Total IVA'); ?></b></td>
                        <td class="text-right"><b><?php echo app('translator')->get('Motivo de isenção'); ?></b></td>
                    </tr>
                </thead>
                <tbody>

                </tbody>
            </table>
        </div>
        <div class="w-40 float-right">
            <table class="table table-sm">
                <tbody>
                    <tr class="">
                        <td><?php echo app('translator')->get('Total usado'); ?></td>
                        <td class="text-right"><?php echo e(number_format($recipt->recieptItems()->sum('amount'),2)); ?></td>
                    </tr>
                    <tr class="">
                        <td><?php echo app('translator')->get('Total adiantado'); ?></td>
                        <td class="text-right"><?php echo e(number_format($recipt->customerAdvance()->sum('amount'), 2)); ?></td>
                    </tr>

                    <tr class="">
                        <td><?php echo app('translator')->get('Total pago'); ?></td>
                        <td class="text-right"><?php echo e(number_format($recipt->amount, 2)); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>


    <div class="container-fluid">
        <table class="" width="100%">
            <tr>
                 <td width="30%"
                    style="border-top: 1px solid #000000; font-size: 9pt; text-align: left; padding-top: 3mm; ">
                    <span class="d-none"> <?php echo app('translator')->get('Pagina'); ?> . ' {PAGENO} ' .<?php echo app('translator')->get('de'); ?> . ' {nb}</span>

                    <i><?php echo e(config('app.name')); ?>, <?php echo app('translator')->get('Licenciado a'); ?> <strong><?php echo e($company->name); ?></strong></i>

                    <br>
                    <sub> <?php echo e(config("app.finance_dep_global_auth")); ?>

                    </sub>
                    <br>
                    <sub><?php echo app('translator')->get('Processado por computador'); ?></sub>
                </td>

                <td width="40%" class="text-right">
                    &nbsp;
                </td>

                <td width="30%"
                    style="border-top: 1px solid #000000; font-size: 9pt; padding-top: 3mm;  text-align: right;">
                    <?php echo app('translator')->get('Impresso por'); ?>: <?php echo e(Auth::user()->name); ?><br><span
                        style="font-size: 7pt;"><?php echo e(now()->format('d/m/Y')); ?></span>
                </td>
            </tr>
        </table>
    </div>
</body>

</html>
<?php /**PATH /home/forge/giwuc.netwarepos.com/resources/views/sales/receipt/print/index.blade.php ENDPATH**/ ?>